/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.localeProvider;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.webapp.locale.LocaleStartup;
import org.nuxeo.runtime.api.Framework;

public class UserLocaleSelectorListener
implements EventListener {
    public static final Log log = LogFactory.getLog(UserLocaleSelectorListener.class);

    public void handleEvent(Event event) {
        DocumentEventContext ctx = (DocumentEventContext)event.getContext();
        DocumentModel userProfileDocument = ctx.getSourceDocument();
        if (!userProfileDocument.hasFacet("UserProfile")) {
            return;
        }
        UserWorkspaceService uws = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        DocumentModel userWorkspace = uws.getCurrentUserPersonalWorkspace(ctx.getCoreSession(), userProfileDocument);
        if (!userProfileDocument.getPathAsString().startsWith(userWorkspace.getPathAsString())) {
            return;
        }
        LocaleStartup localeStartup = LocaleStartup.instance();
        if (localeStartup == null) {
            log.warn((Object)"Locale Startup not available. Can't set locale");
            return;
        }
        localeStartup.setupLocale(userProfileDocument);
    }
}

