/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io;

import java.io.UnsupportedEncodingException;
import org.ajax4jsf.io.CharBuffer;

public class ByteBuffer {
    private static final int MAX_WASTE = 16384;
    private byte[] bytes;
    private int cacheSize;
    private ByteBuffer next;
    private ByteBuffer prev;
    private int usedSize;

    public ByteBuffer(byte[] bytes) {
        this.bytes = bytes;
        this.cacheSize = this.usedSize = bytes.length;
    }

    public ByteBuffer(int cacheSize) {
        this.bytes = new byte[cacheSize];
        this.cacheSize = cacheSize;
        this.usedSize = 0;
    }

    public ByteBuffer append(byte c) {
        if (this.next != null) {
            return this.next.append(c);
        }
        if (this.usedSize < this.cacheSize) {
            this.bytes[this.usedSize] = c;
            ++this.usedSize;
            return this;
        }
        this.next = new ByteBuffer(this.cacheSize * 2);
        this.next.prev = this;
        return this.next.append(c);
    }

    public ByteBuffer append(byte[] bs, int off, int len) {
        if (this.next != null) {
            return this.next.append(bs, off, len);
        }
        if (len + this.usedSize <= this.cacheSize) {
            System.arraycopy(bs, off, this.bytes, this.usedSize, len);
            this.usedSize += len;
            return this;
        }
        int av = this.cacheSize - this.usedSize;
        if (av > 0) {
            System.arraycopy(bs, off, this.bytes, this.usedSize, av);
            this.usedSize += av;
            off += av;
            len -= av;
        }
        this.next = new ByteBuffer(this.cacheSize * 2);
        this.next.prev = this;
        return this.next.append(bs, off, len);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte getByteAt(int index) {
        return this.bytes[index];
    }

    public int getUsedSize() {
        return this.usedSize;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public int getTotalSize() {
        return this.prev == null ? this.usedSize : this.prev.getTotalSize() + this.usedSize;
    }

    public ByteBuffer getPrevious() {
        return this.prev;
    }

    public ByteBuffer getNext() {
        return this.next;
    }

    public void setNext(ByteBuffer b) {
        this.next = b;
        if (b != null) {
            b.prev = this;
        }
    }

    public CharBuffer toCharBuffer(String encoding) throws UnsupportedEncodingException {
        String s = null != encoding ? new String(this.bytes, 0, this.usedSize, encoding) : new String(this.bytes, 0, this.usedSize);
        return new CharBuffer(s.toCharArray());
    }

    public CharBuffer toCharBuffer() {
        String s = new String(this.bytes, 0, this.usedSize);
        return new CharBuffer(s.toCharArray());
    }

    public void reset() {
        this.usedSize = 0;
        this.next = null;
        this.prev = null;
    }

    public void compact() {
        if (this.bytes.length - this.usedSize > 16384) {
            byte[] bs = new byte[this.usedSize];
            System.arraycopy(this.bytes, 0, bs, 0, this.usedSize);
            this.bytes = bs;
            this.cacheSize = bs.length;
        }
        if (this.next != null) {
            this.next.compact();
        }
    }

    public ByteBuffer getLast() {
        ByteBuffer result = this;
        while (result.next != null) {
            result = result.next;
        }
        return result;
    }
}

