/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.user.center.profile.UserProfileActions;
import org.nuxeo.ecm.webapp.action.WebActionsBean;
import org.nuxeo.ecm.webapp.locale.LocaleStartup;

@Name(value="userPreferencesActions")
@Scope(value=ScopeType.CONVERSATION)
public class UserPreferencesActions
extends UserProfileActions {
    public static final Log log = LogFactory.getLog(UserPreferencesActions.class);
    private static final long serialVersionUID = 1L;
    @In
    protected transient WebActionsBean webActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;

    public String navigateToPreferencesPage() {
        this.webActions.setCurrentTabIds("MAIN_TABS:home,USER_CENTER:Preferences");
        return "view_home";
    }

    public void resetTimezone() {
        LocaleStartup localeStartup = LocaleStartup.instance();
        if (localeStartup == null) {
            log.warn((Object)"Locale Startup not available. Can't reset time zone");
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("label.userPreferences.resetTimeZone.error"), new Object[0]);
            return;
        }
        localeStartup.setupLocale(this.documentManager);
        localeStartup.setupTimeZone(this.documentManager);
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("label.userPreferences.resetTimeZone.done"), new Object[0]);
    }
}

