/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.validator;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.application.FacesMessage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.validation.ConstraintViolation;
import org.nuxeo.ecm.core.api.validation.DocumentValidationReport;
import org.nuxeo.ecm.core.api.validation.DocumentValidationService;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.platform.el.DocumentPropertyContext;
import org.nuxeo.ecm.platform.ui.web.model.ProtectedEditableModel;
import org.nuxeo.ecm.platform.ui.web.validator.ValueExpressionAnalyzer;
import org.nuxeo.runtime.api.Framework;

public class DocumentConstraintValidator
implements Validator,
PartialStateHolder {
    private static final Log log = LogFactory.getLog(DocumentConstraintValidator.class);
    public static final String VALIDATOR_ID = "DocumentConstraintValidator";
    public static final String CTX_JSFVALIDATOR = "jsfValidator";
    private boolean transientValue = false;
    private boolean initialState;
    protected Boolean handleSubProperties;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        List<ConstraintViolation> violations;
        if (context == null) {
            throw new NullPointerException();
        }
        if (component == null) {
            throw new NullPointerException();
        }
        ValueExpression ve = component.getValueExpression("value");
        if (ve == null) {
            return;
        }
        ValueExpressionAnalyzer expressionAnalyzer = new ValueExpressionAnalyzer(ve);
        ValueReference vref = expressionAnalyzer.getReference(context.getELContext());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Validating  value '%s' for expression '%s', base=%s, prop=%s", value, ve.getExpressionString(), vref.getBase(), vref.getProperty()));
        }
        if (this.isResolvable(vref, ve) && (violations = this.doValidate(context, vref, ve, value)) != null && !violations.isEmpty()) {
            Locale locale = context.getViewRoot().getLocale();
            if (violations.size() == 1) {
                ConstraintViolation v = violations.iterator().next();
                String msg = v.getMessage(locale);
                throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
            LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(violations.size());
            for (ConstraintViolation v : violations) {
                String msg = v.getMessage(locale);
                messages.add(new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, msg));
            }
            throw new ValidatorException(messages);
        }
    }

    private boolean isResolvable(ValueReference ref, ValueExpression ve) {
        Class<?> baseClass;
        if (ve == null || ref == null) {
            return false;
        }
        Object base = ref.getBase();
        if (base != null && (baseClass = base.getClass()) != null && (DocumentPropertyContext.class.isAssignableFrom(baseClass) || Property.class.isAssignableFrom(baseClass) || ProtectedEditableModel.class.isAssignableFrom(baseClass) || ValueExpressionAnalyzer.ListItemMapper.class.isAssignableFrom(baseClass))) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("NOT validating %s, base=%s, prop=%s", ve.getExpressionString(), base, ref.getProperty()));
        }
        return false;
    }

    protected List<ConstraintViolation> doValidate(FacesContext context, ValueReference vref, ValueExpression e, Object value) {
        DocumentValidationService validationService = (DocumentValidationService)Framework.getService(DocumentValidationService.class);
        DocumentValidationReport report = null;
        if (!validationService.isActivated(CTX_JSFVALIDATOR, null)) {
            return null;
        }
        XPathAndField field = this.resolveField(context, vref, e);
        if (field != null) {
            boolean validateSubs = this.getHandleSubProperties();
            report = validationService.validate(field.xpath, value, validateSubs);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("VALIDATED  value '%s' for expression '%s', base=%s, prop=%s", value, e.getExpressionString(), vref.getBase(), vref.getProperty()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("NOT Validating  value '%s' for expression '%s', base=%s, prop=%s", value, e.getExpressionString(), vref.getBase(), vref.getProperty()));
        }
        if (report != null && report.hasError()) {
            return report.asList();
        }
        return null;
    }

    protected XPathAndField resolveField(FacesContext context, ValueReference vref, ValueExpression ve) {
        Object base = vref.getBase();
        Object propObj = vref.getProperty();
        if (propObj != null && !(propObj instanceof String)) {
            return null;
        }
        String xpath = null;
        Field field = null;
        String prop = (String)propObj;
        Class<?> baseClass = base.getClass();
        if (DocumentPropertyContext.class.isAssignableFrom(baseClass)) {
            DocumentPropertyContext dc = (DocumentPropertyContext)base;
            xpath = dc.getSchema() + ":" + prop;
            field = this.getField(xpath);
        } else if (Property.class.isAssignableFrom(baseClass)) {
            xpath = ((Property)base).getPath() + "/" + prop;
            field = this.getField(((Property)base).getField(), prop);
        } else if (ProtectedEditableModel.class.isAssignableFrom(baseClass)) {
            XPathAndField parentField;
            ProtectedEditableModel model = (ProtectedEditableModel)base;
            ValueExpression listVe = model.getBinding();
            ValueExpressionAnalyzer expressionAnalyzer = new ValueExpressionAnalyzer(listVe);
            ValueReference listRef = expressionAnalyzer.getReference(context.getELContext());
            if (this.isResolvable(listRef, listVe) && (parentField = this.resolveField(context, listRef, listVe)) != null) {
                field = this.getField(parentField.field, "*");
                xpath = parentField.xpath == null ? field.getName().getLocalName() : parentField.xpath + "/" + field.getName().getLocalName();
            }
        } else if (ValueExpressionAnalyzer.ListItemMapper.class.isAssignableFrom(baseClass)) {
            XPathAndField parentField;
            ValueExpressionAnalyzer.ListItemMapper mapper = (ValueExpressionAnalyzer.ListItemMapper)base;
            ProtectedEditableModel model = mapper.getModel();
            ValueExpression listVe = model.getParent() != null ? model.getParent().getBinding() : model.getBinding();
            ValueExpressionAnalyzer expressionAnalyzer = new ValueExpressionAnalyzer(listVe);
            ValueReference listRef = expressionAnalyzer.getReference(context.getELContext());
            if (this.isResolvable(listRef, listVe) && (parentField = this.resolveField(context, listRef, listVe)) != null) {
                field = this.getField(parentField.field, prop);
                if (field == null || field.getName() == null) {
                    return null;
                }
                xpath = parentField.xpath == null ? field.getName().getLocalName() : parentField.xpath + "/" + field.getName().getLocalName();
            }
        } else {
            log.error((Object)String.format("Cannot validate expression '%s, base=%s'", ve.getExpressionString(), base));
        }
        if (xpath != null) {
            xpath = StringUtils.strip((String)xpath, (String)"/");
        } else if (field == null && xpath == null) {
            return null;
        }
        return new XPathAndField(field, xpath);
    }

    protected Field getField(Field field, String subName) {
        SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
        return tm.getField(field, subName);
    }

    protected Field getField(String propertyName) {
        SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
        return tm.getField(propertyName);
    }

    public Boolean getHandleSubProperties() {
        return this.handleSubProperties != null ? this.handleSubProperties : Boolean.TRUE;
    }

    public void setHandleSubProperties(Boolean handleSubProperties) {
        this.clearInitialState();
        this.handleSubProperties = handleSubProperties;
    }

    public Object saveState(FacesContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.handleSubProperties};
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (state != null) {
            Object[] values = (Object[])state;
            this.handleSubProperties = (Boolean)values[0];
        }
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientValue = newTransientValue;
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }

    private class XPathAndField {
        private Field field;
        private String xpath;

        public XPathAndField(Field field, String xpath) {
            this.field = field;
            this.xpath = xpath;
        }
    }
}

