/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.style;

import com.lowagie.text.DocWriter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfExtendedElement;
import com.lowagie.text.rtf.document.RtfDocument;
import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;

public class RtfColor
extends RtfElement
implements RtfExtendedElement {
    private static final byte[] COLOR_RED = DocWriter.getISOBytes((String)"\\red");
    private static final byte[] COLOR_GREEN = DocWriter.getISOBytes((String)"\\green");
    private static final byte[] COLOR_BLUE = DocWriter.getISOBytes((String)"\\blue");
    private static final byte COLON = 59;
    private static final byte[] COLOR_NUMBER = DocWriter.getISOBytes((String)"\\cf");
    private int colorNumber = 0;
    private int red = 0;
    private int green = 0;
    private int blue = 0;

    protected RtfColor(RtfDocument rtfDocument, int n, int n2, int n3, int n4) {
        super(rtfDocument);
        this.red = n;
        this.blue = n3;
        this.green = n2;
        this.colorNumber = n4;
    }

    public RtfColor(RtfDocument rtfDocument, RtfColor rtfColor) {
        super(rtfDocument);
        if (rtfColor != null) {
            this.red = rtfColor.getRed();
            this.green = rtfColor.getGreen();
            this.blue = rtfColor.getBlue();
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument rtfDocument, Color color) {
        super(rtfDocument);
        if (color != null) {
            this.red = color.getRed();
            this.blue = color.getBlue();
            this.green = color.getGreen();
        }
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public RtfColor(RtfDocument rtfDocument, int n, int n2, int n3) {
        super(rtfDocument);
        this.red = n;
        this.blue = n3;
        this.green = n2;
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }

    public void writeContent(OutputStream outputStream) throws IOException {
    }

    public void writeDefinition(OutputStream outputStream) throws IOException {
        outputStream.write(COLOR_RED);
        outputStream.write(this.intToByteArray(this.red));
        outputStream.write(COLOR_GREEN);
        outputStream.write(this.intToByteArray(this.green));
        outputStream.write(COLOR_BLUE);
        outputStream.write(this.intToByteArray(this.blue));
        outputStream.write(59);
    }

    public void writeBegin(OutputStream outputStream) {
        try {
            outputStream.write(COLOR_NUMBER);
            outputStream.write(this.intToByteArray(this.colorNumber));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void writeEnd(OutputStream outputStream) {
    }

    public boolean equals(Object object) {
        if (!(object instanceof RtfColor)) {
            return false;
        }
        RtfColor rtfColor = (RtfColor)object;
        return this.red == rtfColor.getRed() && this.green == rtfColor.getGreen() && this.blue == rtfColor.getBlue();
    }

    public int hashCode() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getGreen() {
        return this.green;
    }

    public int getRed() {
        return this.red;
    }

    public int getColorNumber() {
        return this.colorNumber;
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        super.setRtfDocument(rtfDocument);
        if (this.document != null) {
            this.colorNumber = this.document.getDocumentHeader().getColorNumber(this);
        }
    }
}

