/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.oauth2;

import com.google.api.client.auth.oauth2.Credential;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/oauth2")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="oauth2")
public class OAuth2Callback
extends ModuleRoot {
    @Context
    private HttpServletRequest request;
    Credential credential;
    private static final Log log = LogFactory.getLog(OAuth2Callback.class);

    @GET
    @Path(value="{serviceProviderName}/callback")
    public Object doGet(@PathParam(value="serviceProviderName") String serviceProviderName) throws IOException {
        OAuth2ServiceProviderRegistry registry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
        final OAuth2ServiceProvider provider = registry.getProvider(serviceProviderName);
        if (provider == null) {
            return Response.status((int)404).entity((Object)("No service provider called: \"" + serviceProviderName + "\".")).build();
        }
        final HashMap<String, String> args = new HashMap<String, String>();
        new UnrestrictedSessionRunner(this.ctx.getCoreSession()){

            public void run() {
                try {
                    OAuth2Callback.this.credential = provider.handleAuthorizationCallback(OAuth2Callback.this.request);
                }
                catch (NuxeoException e) {
                    log.error((Object)"Authorization request failed", (Throwable)e);
                    args.put("error", "Authorization request failed");
                }
            }
        }.runUnrestricted();
        String token = this.credential == null ? "" : this.credential.getAccessToken();
        args.put("token", token);
        return this.getView("index").args(args);
    }
}

