/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.excel.jxl;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import jxl.HeaderFooter;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.Orientation;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.format.Pattern;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.WritableFont;
import jxl.write.WriteException;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.excel.ExcelWorkbookException;
import org.jboss.seam.excel.css.CellStyle;
import org.jboss.seam.excel.ui.ExcelComponent;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;

public class JXLFactory {
    private static final String DATEFORMATS_CLASSNAME = "jxl.write.DateFormats";
    private static final String NUMBERFORMATS_CLASSNAME = "jxl.write.NumberFormats";
    private static final String ALIGNMENT_CLASS_NAME = "jxl.format.Alignment";
    private static final String ORIENTATION_CLASS_NAME = "jxl.format.Orientation";
    private static final String VERTICAL_ALIGNMENT_CLASS_NAME = "jxl.format.VerticalAlignment";
    private static final String COLOR_CLASS_NAME = "jxl.format.Colour";
    private static final String BORDER_CLASS_NAME = "jxl.format.Border";
    private static final String BORDER_LINE_STYLE_CLASS_NAME = "jxl.format.BorderLineStyle";
    private static final String PATTERN_CLASS_NAME = "jxl.format.Pattern";
    private static final String PAGE_ORIENTATION_CLASS_NAME = "jxl.format.PageOrientation";
    private static final String PAPER_SIZE_CLASS_NAME = "jxl.format.PaperSize";
    private static final String SCRIPT_STYLE_CLASS_NAME = "jxl.format.ScriptStyle";
    private static final String UNDERLINE_STYLE_CLASS_NAME = "jxl.format.UnderlineStyle";
    private static final String HEADERFOOTER_COMMAND_MARKER = "#";
    private static final String HEADERFOOTER_PAIR_DELIMITER = "=";
    private static final String HF_CMD_FONT_SIZE = "font_size";
    private static final String HF_CMD_FONT_NAME = "font_name";
    private static final String HF_CMD_UNDERLINE = "underline";
    private static final String HF_CMD_SUPERSCRIPT = "superscript";
    private static final String HF_CMD_SUBSCRIPT = "subscript";
    private static final String HF_CMD_STRIKETHROUGH = "strikethrough";
    private static final String HF_CMD_SHADOW = "shadow";
    private static final String HF_CMD_OUTLINE = "outline";
    private static final String HF_CMD_ITALICS = "italics";
    private static final String HF_CMD_DOUBLE_UNDERLINE = "double_underline";
    private static final String HF_CMD_BOLD = "bold";
    private static final String HF_CMD_WORKSHEET_NAME = "worksheet_name";
    private static final String HF_CMD_WORKBOOK_NAME = "workbook_name";
    private static final String HF_CMD_TOTAL_PAGES = "total_pages";
    private static final String HF_CMD_TIME = "time";
    private static final String HF_CMD_PAGE_NUMBER = "page_number";
    private static final Log log = Logging.getLog(JXLFactory.class);

    public static boolean isBorderLineStyle(String text) {
        return JXLFactory.getValidContants(BORDER_LINE_STYLE_CLASS_NAME).contains(text.toLowerCase());
    }

    public static boolean isPattern(String text) {
        return JXLFactory.getValidContants(PATTERN_CLASS_NAME).contains(text.toLowerCase());
    }

    public static boolean isColor(String text) {
        return JXLFactory.getValidContants(COLOR_CLASS_NAME).contains(text.toLowerCase());
    }

    public static boolean isAlignment(String text) {
        return JXLFactory.getValidContants(ALIGNMENT_CLASS_NAME).contains(text.toLowerCase());
    }

    public static boolean isOrientation(String text) {
        return JXLFactory.getValidContants(ORIENTATION_CLASS_NAME).contains(text.toLowerCase());
    }

    public static boolean isVerticalAlignment(String text) {
        return JXLFactory.getValidContants(VERTICAL_ALIGNMENT_CLASS_NAME).contains(text.toLowerCase());
    }

    public static boolean isUnderlineStyle(String text) {
        return JXLFactory.getValidContants(UNDERLINE_STYLE_CLASS_NAME).contains(text.toLowerCase());
    }

    public static boolean isScriptStyle(String text) {
        return JXLFactory.getValidContants(SCRIPT_STYLE_CLASS_NAME).contains(text.toLowerCase());
    }

    private static List<String> getValidContants(String className) {
        ArrayList<String> constants = new ArrayList<String>();
        if (log.isTraceEnabled()) {
            log.trace((Object)"Getting valid constants from #0", new Object[]{className});
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ExcelWorkbookException("Could not find class while getting valid constants", e);
        }
        for (Field field : clazz.getFields()) {
            int modifiers = field.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) continue;
            constants.add(field.getName().toLowerCase());
        }
        return constants;
    }

    public static String getValidConstantsSuggestion(String className) {
        List<String> constants = JXLFactory.getValidContants(className);
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        for (String field : constants) {
            buffer.append(i++ == 0 ? field : ", " + field);
        }
        return Interpolator.instance().interpolate("[#0]", new Object[]{buffer.toString()});
    }

    private static Object getConstant(String className, String fieldName) throws NoSuchFieldException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Looking for constant #0 in class #1", new Object[]{fieldName.toUpperCase(), className});
        }
        try {
            return Class.forName(className).getField(fieldName.toUpperCase()).get(null);
        }
        catch (NoSuchFieldException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExcelWorkbookException(Interpolator.instance().interpolate("Could not read field #0 from class #1", new Object[]{fieldName, className}), e);
        }
    }

    public static Alignment createAlignment(String alignment) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating alignment for #0", new Object[]{alignment});
        }
        try {
            return alignment == null ? Alignment.LEFT : (Alignment)JXLFactory.getConstant(ALIGNMENT_CLASS_NAME, alignment.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Alignment {0} not supported, try {1}", new Object[]{alignment, JXLFactory.getValidConstantsSuggestion(ALIGNMENT_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static ScriptStyle createScriptStyle(String scriptStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating script style for #0", new Object[]{scriptStyle});
        }
        try {
            return scriptStyle == null ? ScriptStyle.NORMAL_SCRIPT : (ScriptStyle)JXLFactory.getConstant(SCRIPT_STYLE_CLASS_NAME, scriptStyle.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Script style {0} not supported, try {1}", new Object[]{scriptStyle, JXLFactory.getValidConstantsSuggestion(SCRIPT_STYLE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    private static UnderlineStyle createUnderlineStyle(String underlineStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating underline style for #0", new Object[]{underlineStyle});
        }
        try {
            return underlineStyle == null ? UnderlineStyle.NO_UNDERLINE : (UnderlineStyle)JXLFactory.getConstant(UNDERLINE_STYLE_CLASS_NAME, underlineStyle.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Underline style {0} not supported, try {1}", new Object[]{underlineStyle, JXLFactory.getValidConstantsSuggestion(UNDERLINE_STYLE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static FontRecord createFont(CellStyle.Font fontspecs) throws WriteException {
        WritableFont font = null;
        font = fontspecs.family != null ? new WritableFont(WritableFont.createFont((String)fontspecs.family)) : new WritableFont(WritableFont.ARIAL);
        if (fontspecs.pointSize != null) {
            font.setPointSize(fontspecs.pointSize.intValue());
        }
        if (fontspecs.color != null) {
            font.setColour(JXLFactory.createColor(fontspecs.color));
        }
        if (fontspecs.bold != null) {
            font.setBoldStyle(fontspecs.bold != false ? WritableFont.BOLD : WritableFont.NO_BOLD);
        }
        if (fontspecs.italic != null) {
            font.setItalic(fontspecs.italic.booleanValue());
        }
        if (fontspecs.struckOut != null) {
            font.setStruckout(fontspecs.struckOut.booleanValue());
        }
        if (fontspecs.scriptStyle != null) {
            font.setScriptStyle(JXLFactory.createScriptStyle(fontspecs.scriptStyle));
        }
        if (fontspecs.underlineStyle != null) {
            font.setUnderlineStyle(JXLFactory.createUnderlineStyle(fontspecs.underlineStyle));
        }
        return font;
    }

    public static DisplayFormat createNumberFormat(String formatMask) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating number format for mask #0", new Object[]{formatMask});
        }
        try {
            return (DisplayFormat)JXLFactory.getConstant(NUMBERFORMATS_CLASSNAME, formatMask);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static DisplayFormat createDateFormat(String mask) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating date format for mask #0", new Object[]{mask});
        }
        try {
            return (DisplayFormat)JXLFactory.getConstant(DATEFORMATS_CLASSNAME, mask.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Colour createColor(String color) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating color for #0", new Object[]{color});
        }
        if (color.equalsIgnoreCase("black")) {
            color = "palette_black";
        }
        try {
            return color == null ? Colour.AUTOMATIC : (Colour)JXLFactory.getConstant(COLOR_CLASS_NAME, color.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Color {0} not supported, try {1}", new Object[]{color, JXLFactory.getValidConstantsSuggestion(COLOR_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static Orientation createOrientation(String orientation) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating orientation for #0", new Object[]{orientation});
        }
        try {
            return orientation == null ? Orientation.HORIZONTAL : (Orientation)JXLFactory.getConstant(ORIENTATION_CLASS_NAME, orientation.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Orientation {0} not supported, try {1}", new Object[]{orientation, JXLFactory.getValidConstantsSuggestion(ORIENTATION_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static VerticalAlignment createVerticalAlignment(String verticalAlignment) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating verical alignment for #0", new Object[]{verticalAlignment});
        }
        try {
            return verticalAlignment == null ? VerticalAlignment.BOTTOM : (VerticalAlignment)JXLFactory.getConstant(VERTICAL_ALIGNMENT_CLASS_NAME, verticalAlignment.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Verical alignment {0} not supported, try {1}", new Object[]{verticalAlignment, JXLFactory.getValidConstantsSuggestion(VERTICAL_ALIGNMENT_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static Border createBorder(String border) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating border for #0", new Object[]{border});
        }
        try {
            return border == null ? Border.ALL : (Border)JXLFactory.getConstant(BORDER_CLASS_NAME, border.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Border {0} not supported, try {1}", new Object[]{border, JXLFactory.getValidConstantsSuggestion(BORDER_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static BorderLineStyle createLineStyle(String borderLineStyle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating border line style for #0", new Object[]{borderLineStyle});
        }
        try {
            return borderLineStyle == null ? BorderLineStyle.NONE : (BorderLineStyle)JXLFactory.getConstant(BORDER_LINE_STYLE_CLASS_NAME, borderLineStyle.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Border line style {0} not supported, try {1}", new Object[]{borderLineStyle, JXLFactory.getValidConstantsSuggestion(BORDER_LINE_STYLE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static Pattern createPattern(String pattern) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating pattern for #0", new Object[]{pattern});
        }
        try {
            return pattern == null ? Pattern.SOLID : (Pattern)JXLFactory.getConstant(PATTERN_CLASS_NAME, pattern.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Pattern {0} not supported, try {1}", new Object[]{pattern, JXLFactory.getValidConstantsSuggestion(PATTERN_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static PageOrientation createPageOrientation(String orientation) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating page orientation for #0", new Object[]{orientation});
        }
        try {
            return orientation == null ? PageOrientation.LANDSCAPE : (PageOrientation)JXLFactory.getConstant(PAGE_ORIENTATION_CLASS_NAME, orientation.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Page orientation {0} not supported, try {1}", new Object[]{orientation, JXLFactory.getValidConstantsSuggestion(PAGE_ORIENTATION_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static PaperSize createPaperSize(String paperSize) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Creating paper size for #0", new Object[]{paperSize});
        }
        try {
            return paperSize == null ? PaperSize.A4 : (PaperSize)JXLFactory.getConstant(PAPER_SIZE_CLASS_NAME, paperSize.toUpperCase());
        }
        catch (NoSuchFieldException e) {
            String message = Interpolator.instance().interpolate("Page size {0} not supported, try {1}", new Object[]{paperSize, JXLFactory.getValidConstantsSuggestion(PAPER_SIZE_CLASS_NAME)});
            throw new ExcelWorkbookException(message, e);
        }
    }

    public static HeaderFooter createHeaderFooter(UIComponent uiHeaderFooter, HeaderFooter headerFooter) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing header/footer #0", new Object[]{uiHeaderFooter});
        }
        JXLFactory.processHeaderFooterFacet(headerFooter.getLeft(), uiHeaderFooter.getFacet("left"));
        JXLFactory.processHeaderFooterFacet(headerFooter.getCentre(), uiHeaderFooter.getFacet("center"));
        JXLFactory.processHeaderFooterFacet(headerFooter.getRight(), uiHeaderFooter.getFacet("right"));
        return headerFooter;
    }

    private static void processHeaderFooterFacet(HeaderFooter.Contents contents, UIComponent facet) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Processing facet #0 of header/footer #1", new Object[]{facet, contents});
        }
        if (facet == null) {
            return;
        }
        String facetContent = null;
        try {
            facetContent = ExcelComponent.cmp2String(FacesContext.getCurrentInstance(), facet);
        }
        catch (IOException e) {
            throw new ExcelWorkbookException("Could not get content from header facet", e);
        }
        if (facetContent == null) {
            return;
        }
        facetContent = facetContent.trim();
        while (!"".equals(facetContent)) {
            int firstHash = -1;
            int secondHash = -1;
            firstHash = facetContent.indexOf(HEADERFOOTER_COMMAND_MARKER);
            if (firstHash >= 0) {
                secondHash = facetContent.indexOf(HEADERFOOTER_COMMAND_MARKER, firstHash + 1);
            }
            if (firstHash >= 0 && secondHash >= 0 && firstHash != secondHash) {
                String pre = facetContent.substring(0, firstHash);
                if (!"".equals(pre)) {
                    contents.append(pre);
                }
                String command = facetContent.substring(firstHash + 1, secondHash);
                JXLFactory.processCommand(contents, command);
                facetContent = facetContent.substring(secondHash + 1);
                continue;
            }
            contents.append(facetContent);
            facetContent = "";
        }
    }

    private static void processCommand(HeaderFooter.Contents contents, String command) {
        if ((command = command.toLowerCase()).startsWith("date")) {
            contents.appendDate();
        } else if (command.startsWith(HF_CMD_PAGE_NUMBER)) {
            contents.appendPageNumber();
        } else if (command.startsWith(HF_CMD_TIME)) {
            contents.appendTime();
        } else if (command.startsWith(HF_CMD_TOTAL_PAGES)) {
            contents.appendTotalPages();
        } else if (command.startsWith(HF_CMD_WORKBOOK_NAME)) {
            contents.appendWorkbookName();
        } else if (command.startsWith(HF_CMD_WORKSHEET_NAME)) {
            contents.appendWorkSheetName();
        } else if (command.startsWith(HF_CMD_BOLD)) {
            contents.toggleBold();
        } else if (command.startsWith(HF_CMD_DOUBLE_UNDERLINE)) {
            contents.toggleDoubleUnderline();
        } else if (command.startsWith(HF_CMD_ITALICS)) {
            contents.toggleItalics();
        } else if (command.startsWith(HF_CMD_OUTLINE)) {
            contents.toggleOutline();
        } else if (command.startsWith(HF_CMD_SHADOW)) {
            contents.toggleShadow();
        } else if (command.startsWith(HF_CMD_STRIKETHROUGH)) {
            contents.toggleStrikethrough();
        } else if (command.startsWith(HF_CMD_SUBSCRIPT)) {
            contents.toggleSubScript();
        } else if (command.startsWith(HF_CMD_SUPERSCRIPT)) {
            contents.toggleSuperScript();
        } else if (command.startsWith(HF_CMD_UNDERLINE)) {
            contents.toggleUnderline();
        } else if (command.startsWith(HF_CMD_FONT_NAME)) {
            String[] parts = command.split(HEADERFOOTER_PAIR_DELIMITER);
            if (parts.length != 2) {
                log.warn((Object)"Header/Footer font name error in #0", new Object[]{command});
            }
            contents.setFontName(parts[1].trim());
        } else if (command.startsWith(HF_CMD_FONT_SIZE)) {
            String[] parts = command.split(HEADERFOOTER_PAIR_DELIMITER);
            if (parts.length != 2) {
                log.warn((Object)"Header/Footer font size error in #0", new Object[]{command});
            }
            contents.setFontSize(Integer.parseInt(parts[1].trim()));
        }
    }
}

