/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.jsf;

import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import org.nuxeo.ecm.platform.ui.web.binding.MetaValueExpression;

public class MetaValueHolderRule
extends MetaRule {
    public static final MetaValueHolderRule Instance = new MetaValueHolderRule();

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        if (meta.isTargetInstanceOf(ValueHolder.class) && "value".equals(name)) {
            if (attribute.isLiteral()) {
                return new LiteralValueMetadata(attribute.getValue());
            }
            return new MetaValueExpressionMetadata(attribute);
        }
        return null;
    }

    static final class MetaValueExpressionMetadata
    extends Metadata {
        private final TagAttribute attr;

        MetaValueExpressionMetadata(TagAttribute attr) {
            this.attr = attr;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ValueExpression originalExpression = this.attr.getValueExpression(ctx, Object.class);
            ((UIComponent)instance).setValueExpression("value", (ValueExpression)new MetaValueExpression(originalExpression, ctx.getFunctionMapper(), ctx.getVariableMapper()));
        }
    }

    static final class LiteralValueMetadata
    extends Metadata {
        private final String value;

        LiteralValueMetadata(String value) {
            this.value = value;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            ((ValueHolder)instance).setValue((Object)this.value);
        }
    }
}

