/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import com.sun.faces.facelets.tag.TagAttributeImpl;
import com.sun.faces.facelets.tag.TagAttributesImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.MetaTagHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.directory.UIDirectorySelectItems;
import org.nuxeo.ecm.platform.ui.web.tag.handler.GenericHtmlComponentHandler;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;

public class DirectorySelectOneListboxHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(DirectorySelectOneListboxHandler.class);
    static final List<String> deprecatedProps = new ArrayList<String>();
    static List<String> optionProps;
    protected final TagConfig tagConfig;
    protected List<TagAttribute> select;
    protected List<TagAttribute> options;

    public DirectorySelectOneListboxHandler(TagConfig config) {
        super(config);
        this.tagConfig = config;
        this.initAttributes(this.tag.getAttributes().getAll());
    }

    protected void initAttributes(TagAttribute[] attrs) {
        this.select = new ArrayList<TagAttribute>();
        this.options = new ArrayList<TagAttribute>();
        boolean orderingFound = false;
        if (attrs != null) {
            for (TagAttribute attr : attrs) {
                String name = attr.getLocalName();
                if (StringUtils.equals((CharSequence)name, (CharSequence)OptionPropertyKeys.ordering.name())) {
                    orderingFound = true;
                }
                if (optionProps.contains(name)) {
                    this.options.add(attr);
                    continue;
                }
                if (deprecatedProps.contains(name)) {
                    log.error((Object)String.format("Property %s is not taken into account anymore on tag nxdir:selectOneListbox", name));
                }
                this.select.add(attr);
            }
        }
        this.options.add(this.getTagAttribute("var", "item"));
        this.options.add(this.getTagAttribute("itemValue", "#{item.id}"));
        if (!orderingFound) {
            this.options.add(this.getTagAttribute(OptionPropertyKeys.ordering.name(), "label"));
        }
    }

    protected TagAttribute getTagAttribute(String name, String value) {
        return new TagAttributeImpl(this.tagConfig.getTag().getLocation(), this.tagConfig.getTag().getNamespace(), name, name, value);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        TagAttributesImpl optionAttributes = new TagAttributesImpl(this.options.toArray(new TagAttribute[0]));
        ComponentConfig optionsConfig = TagConfigFactory.createComponentConfig(this.tagConfig, this.tagConfig.getTagId(), (TagAttributes)optionAttributes, new FaceletHandler(){

            public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
            }
        }, UIDirectorySelectItems.COMPONENT_TYPE, null);
        GenericHtmlComponentHandler optionsHandler = new GenericHtmlComponentHandler(optionsConfig);
        TagAttributesImpl selectAttributes = new TagAttributesImpl(this.select.toArray(new TagAttribute[0]));
        ComponentConfig selectConfig = TagConfigFactory.createComponentConfig(this.tagConfig, this.tagConfig.getTagId(), (TagAttributes)selectAttributes, (FaceletHandler)optionsHandler, this.getSelectComponentType(), null);
        new GenericHtmlComponentHandler(selectConfig).apply(ctx, parent);
    }

    protected String getSelectComponentType() {
        return "javax.faces.HtmlSelectOneListbox";
    }

    protected MetaRuleset createMetaRuleset(Class type) {
        return null;
    }

    static {
        for (DeprecatedPropertyKeys deprecatedPropertyKeys : DeprecatedPropertyKeys.values()) {
            deprecatedProps.add(deprecatedPropertyKeys.name());
        }
        optionProps = new ArrayList<String>();
        for (Enum enum_ : OptionPropertyKeys.values()) {
            optionProps.add(enum_.name());
        }
    }

    protected static enum OptionPropertyKeys {
        directoryName,
        localize,
        displayIdAndLabel,
        ordering,
        caseSensistive,
        displayObsoleteEntries,
        notDisplayDefaultOption,
        filter;

    }

    protected static enum DeprecatedPropertyKeys {
        displayValueOnly;

    }
}

