/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.util.Collection;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public final class DirectoryFunctions {
    private DirectoryFunctions() {
    }

    public static DocumentModel getDirectoryEntry(String directoryName, String entryId) {
        if (entryId == null) {
            return null;
        }
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = dirService.open(directoryName);){
            DocumentModel documentModel = session.getEntry(entryId);
            return documentModel;
        }
    }

    public static DocumentModelList getDirectoryEntries(String directoryName, String ... entryIds) {
        if (entryIds == null) {
            return null;
        }
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        try (Session session = dirService.open(directoryName);){
            DocumentModelListImpl result = new DocumentModelListImpl();
            for (DocumentModelListImpl entryId : entryIds) {
                DocumentModel entry = session.getEntry((String)entryId);
                if (entry == null) continue;
                result.add((Object)entry);
            }
            DocumentModelListImpl documentModelListImpl = result;
            return documentModelListImpl;
        }
    }

    public static DocumentModelList getDirectoryListEntries(String directoryName, Collection<String> entryIds) {
        if (entryIds == null) {
            return null;
        }
        return DirectoryFunctions.getDirectoryEntries(directoryName, entryIds.toArray(new String[0]));
    }
}

