/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.contentview.seam;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.jsf.JSFActionContext;
import org.nuxeo.ecm.platform.actions.seam.SeamActionContext;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewCache;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewState;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewRestActions;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.util.SeamContextHelper;

@Name(value="contentViewActions")
@Scope(value=ScopeType.CONVERSATION)
public class ContentViewActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected ContentViewRestActions contentViewRestActions;
    @In(create=true)
    protected ContentViewService contentViewService;
    protected final ContentViewCache cache = new ContentViewCache();
    protected Long globalPageSize;
    @In(create=true)
    private transient NuxeoPrincipal currentNuxeoPrincipal;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient WebActions webActions;
    protected ContentView currentContentView;

    public ContentView getCurrentContentView() {
        return this.currentContentView;
    }

    public void setCurrentContentView(ContentView cv) {
        this.currentContentView = cv;
    }

    public Long getCurrentGlobalPageSize() {
        if (this.currentContentView != null && this.currentContentView.getUseGlobalPageSize()) {
            return this.currentContentView.getCurrentPageSize();
        }
        return this.globalPageSize;
    }

    public void setCurrentGlobalPageSize(Long pageSize) {
        this.globalPageSize = pageSize;
    }

    public Long getGlobalPageSize() {
        return this.globalPageSize;
    }

    public List<SelectItem> getPageSizeOptions(ContentView cv) {
        Long globalSize;
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        if (cv == null) {
            return items;
        }
        ArrayList<Long> values = new ArrayList<Long>();
        long maxPageSize = 0L;
        PageProvider<?> pp = cv.getCurrentPageProvider();
        if (pp != null) {
            List options = pp.getPageSizeOptions();
            if (options != null) {
                values.addAll(options);
            }
            maxPageSize = pp.getMaxPageSize();
        }
        if (cv.getUseGlobalPageSize() && (globalSize = this.getGlobalPageSize()) != null && globalSize > 0L && !values.contains(globalSize)) {
            values.add(globalSize);
        }
        Collections.sort(values);
        for (Long value : values) {
            if (maxPageSize > 0L && maxPageSize < value) break;
            items.add(new SelectItem((Object)value));
        }
        if (items.isEmpty()) {
            if (maxPageSize > 0L) {
                items.add(new SelectItem((Object)maxPageSize));
            } else {
                items.add(new SelectItem((Object)1));
            }
        }
        return items;
    }

    public void setGlobalPageSize(Long pageSize) {
        this.globalPageSize = pageSize;
    }

    public ContentView getContentView(String name) {
        return this.getContentView(name, null);
    }

    public ContentView getContentView(String name, DocumentModel searchDocumentModel) {
        ContentView cView = this.cache.get(name);
        if (cView == null && (cView = this.contentViewService.getContentView(name)) != null) {
            this.cache.add(cView);
        }
        if (cView != null) {
            if (searchDocumentModel != null) {
                cView.setSearchDocumentModel(searchDocumentModel);
            }
            this.setCurrentContentView(cView);
        }
        return cView;
    }

    public ContentView getContentViewWithProvider(String name) {
        return this.getContentViewWithProvider(name, null, null, null, null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel) {
        return this.getContentViewWithProvider(name, searchDocumentModel, null, null, null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long pageSize, Long currentPage) {
        return this.getContentViewWithProvider(name, searchDocumentModel, sortInfos, pageSize, currentPage, (Object[])null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long defaultPageSize, Long pageSize, Long currentPage) {
        return this.getContentViewWithProvider(name, searchDocumentModel, sortInfos, defaultPageSize, pageSize, currentPage, (Object[])null);
    }

    public ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Object ... params) {
        return this.getContentViewWithProvider(name, searchDocumentModel, sortInfos, (Long)-1L, pageSize, currentPage, params);
    }

    protected ContentView getContentViewWithProvider(String name, DocumentModel searchDocumentModel, List<SortInfo> sortInfos, Long defaultPageSize, Long pageSize, Long currentPage, Object ... params) {
        ContentView cView = this.getContentView(name, searchDocumentModel);
        if (cView != null) {
            if (cView.getUseGlobalPageSize()) {
                cView.setCurrentPageSize(this.globalPageSize);
            }
            if (cView.getCurrentPageSize() == null && defaultPageSize != null && defaultPageSize >= 0L) {
                cView.setCurrentPageSize(defaultPageSize);
            }
            cView.getPageProvider(searchDocumentModel, sortInfos, pageSize, currentPage, params);
        }
        return cView;
    }

    public ContentView restoreContentView(String contentViewName, Long currentPage, Long pageSize, List<SortInfo> sortInfos, String jsonContentViewState) throws IOException {
        ContentView cv = this.contentViewRestActions.restoreContentView(contentViewName, currentPage, pageSize, sortInfos, jsonContentViewState);
        this.cache.add(cv);
        return cv;
    }

    public ContentView restoreContentView(ContentViewState state) throws UnsupportedEncodingException {
        ContentView cv = this.contentViewService.restoreContentView(state);
        this.cache.add(cv);
        return cv;
    }

    @BypassInterceptors
    public void refreshOnSeamEvent(String seamEventName) {
        this.cache.refreshOnEvent(seamEventName);
    }

    @BypassInterceptors
    public void resetPageProviderOnSeamEvent(String seamEventName) {
        this.cache.resetPageProviderOnEvent(seamEventName);
    }

    @BypassInterceptors
    public void refresh(String contentViewName) {
        this.cache.refresh(contentViewName, false);
    }

    @BypassInterceptors
    public void refreshAndRewind(String contentViewName) {
        this.cache.refresh(contentViewName, true);
    }

    @BypassInterceptors
    public void resetAggregates(String contentViewName) {
        this.cache.resetPageProviderAggregates(contentViewName);
    }

    @BypassInterceptors
    public void resetPageProvider(String contentViewName) {
        this.cache.resetPageProvider(contentViewName);
    }

    @BypassInterceptors
    public void reset(String contentViewName) {
        this.cache.reset(contentViewName);
    }

    @BypassInterceptors
    public void resetAllContent() {
        this.cache.resetAllContent();
    }

    @BypassInterceptors
    public void resetAll() {
        this.cache.resetAll();
    }

    @BypassInterceptors
    public void refreshAll() {
        this.cache.refreshAll();
    }

    @BypassInterceptors
    public void refreshAndRewindAll() {
        this.cache.refreshAndRewindAll();
    }

    public List<Action> getActionsList(String category, DocumentModel currentDocument, ContentView contentView, Object showPageSizeSelector, Object showRefreshCommand, Object showCSVExport, Object showPDFExport, Object showSyndicationLinks, Object showSlideshow, Object showEditColumns, Object showEditRows, Object showSpreadsheet) {
        return this.webActions.getActionsList(category, this.createContentViewActionContext(currentDocument, contentView, showPageSizeSelector, showRefreshCommand, showCSVExport, showPDFExport, showSyndicationLinks, showSlideshow, showEditColumns, showEditRows, showSpreadsheet));
    }

    protected ActionContext createContentViewActionContext(DocumentModel currentDocument, ContentView contentView, Object showPageSizeSelector, Object showRefreshCommand, Object showCSVExport, Object showPDFExport, Object showSyndicationLinks, Object showSlideshow, Object showEditColumns, Object showEditRows, Object showSpreadsheet) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Object ctx = faces == null ? new SeamActionContext() : new JSFActionContext(faces);
        ctx.setCurrentPrincipal(this.currentNuxeoPrincipal);
        ctx.setDocumentManager(this.documentManager);
        ctx.setCurrentDocument(currentDocument);
        ctx.putLocalVariable("SeamContext", (Object)new SeamContextHelper());
        ctx.putLocalVariable("contentView", (Object)contentView);
        ctx.putLocalVariable("showPageSizeSelector", showPageSizeSelector);
        ctx.putLocalVariable("showRefreshCommand", showRefreshCommand);
        ctx.putLocalVariable("showCSVExport", showCSVExport);
        ctx.putLocalVariable("showPDFExport", showPDFExport);
        ctx.putLocalVariable("showSyndicationLinks", showSyndicationLinks);
        ctx.putLocalVariable("showSlideshow", showSlideshow);
        ctx.putLocalVariable("showEditColumns", showEditColumns);
        ctx.putLocalVariable("showEditRows", showEditRows);
        ctx.putLocalVariable("showSpreadsheet", showSpreadsheet);
        return ctx;
    }
}

