/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.IOException;
import java.net.URLEncoder;
import java.security.Principal;
import javax.servlet.ServletRequest;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.CloseableCoreSession;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;

public class OpenSearchRestlet
extends BaseNuxeoRestlet {
    public static final String RSS_TAG = "rss";
    public static final String CHANNEL_TAG = "channel";
    public static final String TITLE_TAG = "title";
    public static final String DESCRIPTION_TAG = "description";
    public static final String LINK_TAG = "link";
    public static final String ITEM_TAG = "item";
    public static final String QUERY = "SELECT * FROM Document WHERE ecm:fulltext LIKE '%s' ORDER BY dc:modified DESC";
    public static final int MAX = 10;
    public static final Namespace OPENSEARCH_NS = new Namespace("opensearch", "http://a9.com/-/spec/opensearch/1.1/");
    public static final Namespace ATOM_NS = new Namespace("atom", "http://www.w3.org/2005/Atom");

    public void handle(Request req, Response res) {
        try (CloseableCoreSession session = CoreInstance.openCoreSession(null, (Principal)OpenSearchRestlet.getUserPrincipal(req));){
            String keywords = OpenSearchRestlet.getQueryParamValue(req, "q", " ");
            String query = String.format(QUERY, keywords);
            DocumentModelList documents = session.query(query, null, 10L, 0L, true);
            DOMDocumentFactory domFactory = new DOMDocumentFactory();
            DOMDocument resultDocument = (DOMDocument)domFactory.createDocument();
            Element rssElement = resultDocument.addElement(RSS_TAG);
            rssElement.addAttribute("version", "2.0");
            rssElement.addNamespace(OPENSEARCH_NS.getPrefix(), OPENSEARCH_NS.getURI());
            rssElement.addNamespace(ATOM_NS.getPrefix(), ATOM_NS.getURI());
            Element channelElement = rssElement.addElement(CHANNEL_TAG);
            channelElement.addElement(TITLE_TAG).setText("Nuxeo EP OpenSearch channel for " + keywords);
            channelElement.addElement(LINK_TAG).setText(BaseURL.getBaseURL((ServletRequest)OpenSearchRestlet.getHttpRequest(req)) + "restAPI/opensearch?q=" + URLEncoder.encode(keywords, "UTF-8"));
            channelElement.addElement(new QName("totalResults", OPENSEARCH_NS)).setText(Long.toString(documents.totalSize()));
            channelElement.addElement(new QName("startIndex", OPENSEARCH_NS)).setText("0");
            channelElement.addElement(new QName("itemsPerPage", OPENSEARCH_NS)).setText(Integer.toString(documents.size()));
            Element queryElement = channelElement.addElement(new QName("Query", OPENSEARCH_NS));
            queryElement.addAttribute("role", "request");
            queryElement.addAttribute("searchTerms", keywords);
            queryElement.addAttribute("startPage", Integer.toString(1));
            String baseUrl = BaseURL.getBaseURL((ServletRequest)OpenSearchRestlet.getHttpRequest(req));
            for (DocumentModel doc : documents) {
                Element itemElement = channelElement.addElement(ITEM_TAG);
                Element titleElement = itemElement.addElement(TITLE_TAG);
                String title = doc.getTitle();
                if (title != null) {
                    titleElement.setText(title);
                }
                Element descriptionElement = itemElement.addElement(DESCRIPTION_TAG);
                String description = (String)doc.getProperty("dublincore:description").getValue(String.class);
                if (description != null) {
                    descriptionElement.setText(description);
                }
                Element linkElement = itemElement.addElement(LINK_TAG);
                linkElement.setText(baseUrl + DocumentModelFunctions.documentUrl(doc));
            }
            StringRepresentation rep = new StringRepresentation((CharSequence)resultDocument.asXML(), MediaType.APPLICATION_XML);
            rep.setCharacterSet(CharacterSet.UTF_8);
            res.setEntity((Representation)rep);
        }
        catch (IOException | NuxeoException e) {
            OpenSearchRestlet.handleError(res, (Exception)e);
        }
    }
}

