/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.note;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Part;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.ListDiff;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.note.EditorImageActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="editorImageActions")
@Scope(value=ScopeType.CONVERSATION)
public class EditorImageActionsBean
extends InputController
implements EditorImageActions,
Serializable {
    private static final String FILES_SCHEMA = "files";
    private static final List<Map<String, String>> SIZES = new ArrayList<Map<String, String>>();
    private static final String PP_SEARCH_MEDIA_BY_TITLE = "search_media_by_title";
    private static final String PP_SEARCH_MEDIA_ALL = "search_media_all";
    private static final long serialVersionUID = 8716548847393060676L;
    private static final Log log;
    @In(create=true, required=false)
    private transient CoreSession documentManager;
    @RequestParameter
    private String selectedTab;
    private String oldSelectedTab;
    private Part uploadedImage;
    @Deprecated
    private String uploadedImageName;
    private String imageUrl;
    private boolean isImageUploaded = false;
    private List<DocumentModel> resultDocuments;
    private List<DocumentModel> resultVideos;
    private boolean hasSearchResults = false;
    private boolean hasSearchVideosResults = false;
    private String searchKeywords;
    private String selectedSize = "OriginalJpeg";

    @Override
    public String getSelectedTab() {
        if (this.selectedTab != null) {
            this.oldSelectedTab = this.selectedTab;
        } else if (this.oldSelectedTab == null) {
            this.oldSelectedTab = "UPLOAD";
        }
        return this.oldSelectedTab;
    }

    @Override
    public String getUrlForImage() {
        this.isImageUploaded = false;
        return this.imageUrl;
    }

    @Override
    public boolean getIsImageUploaded() {
        return this.isImageUploaded;
    }

    @Override
    public void setUploadedImage(Part uploadedImage) {
        this.uploadedImage = uploadedImage;
    }

    @Override
    public Part getUploadedImage() {
        return this.uploadedImage;
    }

    @Override
    public String getUploadedImageName() {
        return this.uploadedImageName;
    }

    @Override
    public void setUploadedImageName(String uploadedImageName) {
        this.uploadedImageName = uploadedImageName;
    }

    @Override
    public String uploadImage() {
        Blob blob;
        if (this.uploadedImage == null) {
            return null;
        }
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        List filesList = (List)doc.getProperty(FILES_SCHEMA, FILES_SCHEMA);
        int fileIndex = filesList == null ? 0 : filesList.size();
        HashMap<String, Blob> props = new HashMap<String, Blob>();
        try {
            blob = FileUtils.createBlob((Part)this.uploadedImage);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        props.put("file", blob);
        ListDiff listDiff = new ListDiff();
        listDiff.add(props);
        doc.setProperty(FILES_SCHEMA, FILES_SCHEMA, (Object)listDiff);
        this.documentManager.saveDocument(doc);
        this.documentManager.save();
        this.imageUrl = DocumentModelFunctions.complexFileUrl((String)"downloadFile", (DocumentModel)doc, (int)fileIndex, (String)blob.getFilename());
        this.isImageUploaded = true;
        return "editor_image_upload";
    }

    @Override
    public boolean getInCreationMode() {
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        if (doc == null || doc.getRef() != null) {
            doc = this.navigationContext.getCurrentDocument();
        }
        if (doc == null) {
            return false;
        }
        if (doc.getId() == null) {
            return true;
        }
        return !doc.hasSchema(FILES_SCHEMA);
    }

    @Override
    public boolean getHasSearchResults() {
        return this.hasSearchResults;
    }

    @Override
    public boolean getHasSearchVideosResults() {
        return this.hasSearchVideosResults;
    }

    @Override
    public List<DocumentModel> getSearchImageResults() {
        return this.resultDocuments;
    }

    @Override
    public List<DocumentModel> getSearchVideosResults() {
        return this.resultVideos;
    }

    @Override
    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    @Override
    public String searchImages() {
        this.resultDocuments = null;
        this.resultDocuments = this.searchMedia("Picture");
        this.hasSearchResults = !this.resultDocuments.isEmpty();
        log.debug((Object)("query result contains: " + this.resultDocuments.size() + " docs."));
        return "editor_image_upload";
    }

    @Override
    public String searchVideos() {
        this.resultVideos = null;
        this.resultVideos = this.searchMedia("Video");
        this.hasSearchVideosResults = !this.resultVideos.isEmpty();
        log.debug((Object)("query result contains: " + this.resultVideos.size() + " videos."));
        return "editor_image_upload";
    }

    private List<DocumentModel> searchMedia(String typeDocument) {
        log.debug((Object)("Entering searchDocuments with keywords: " + this.searchKeywords));
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.documentManager);
        PageProvider pp = null;
        if (this.searchKeywords != null) {
            this.searchKeywords = this.searchKeywords.trim();
            if (this.searchKeywords.length() > 0 && !this.searchKeywords.equals("*")) {
                pp = ppService.getPageProvider(PP_SEARCH_MEDIA_BY_TITLE, null, null, null, props, new Object[]{typeDocument, this.searchKeywords});
            }
        }
        if (pp == null) {
            pp = ppService.getPageProvider(PP_SEARCH_MEDIA_ALL, null, null, null, props, new Object[]{typeDocument});
        }
        return pp.getCurrentPage();
    }

    @Override
    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    @Override
    public List<Map<String, String>> getSizes() {
        return SIZES;
    }

    @Override
    public String getSelectedSize() {
        return this.selectedSize;
    }

    @Override
    public void setSelectedSize(String selectedSize) {
        this.selectedSize = selectedSize;
    }

    @Override
    public String getImageProperty() {
        return this.selectedSize + ":content";
    }

    @Override
    public String getURLVideo(DocumentModel video, String type) {
        if (video == null || type == null) {
            return null;
        }
        List transcodedVideos = (List)((Object)video.getPropertyValue("vid:transcodedVideos"));
        int position = 0;
        for (Map prop : transcodedVideos) {
            if (type.equals(prop.get("name"))) {
                Blob content = (Blob)prop.get("content");
                String blobPropertyName = "vid:transcodedVideos/" + position + "/content";
                return DocumentModelFunctions.bigFileUrl((DocumentModel)video, (String)blobPropertyName, (String)content.getFilename());
            }
            ++position;
        }
        return null;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("label", "label.imageUpload.originalSize");
        m.put("value", "OriginalJpeg");
        SIZES.add(m);
        m = new HashMap();
        m.put("label", "label.imageUpload.mediumSize");
        m.put("value", "Medium");
        SIZES.add(m);
        m = new HashMap();
        m.put("label", "label.imageUpload.thumbnailSize");
        m.put("value", "Thumbnail");
        SIZES.add(m);
        log = LogFactory.getLog(EditorImageActionsBean.class);
    }
}

