/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.DocWriter;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.RtfMapper;
import com.lowagie.text.rtf.document.RtfDocumentHeader;
import com.lowagie.text.rtf.document.RtfDocumentSettings;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.output.RtfDataCache;
import com.lowagie.text.rtf.document.output.RtfDiskCache;
import com.lowagie.text.rtf.document.output.RtfEfficientMemoryCache;
import com.lowagie.text.rtf.document.output.RtfMemoryCache;
import com.lowagie.text.rtf.graphic.RtfImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class RtfDocument
extends RtfElement {
    private RtfDataCache data = new RtfMemoryCache();
    private RtfMapper mapper = new RtfMapper(this);
    private RtfDocumentHeader documentHeader = new RtfDocumentHeader(this);
    private ArrayList previousRandomInts = null;
    private boolean autogenerateTOCEntries = false;
    private RtfDocumentSettings documentSettings = null;
    private RtfBasicElement lastElementWritten = null;
    private static final byte[] RTF_DOCUMENT = DocWriter.getISOBytes((String)"\\rtf1");
    private static final byte[] FSC_LINE = DocWriter.getISOBytes((String)"\\line ");
    private static final byte[] FSC_PAR = DocWriter.getISOBytes((String)"\\par ");
    private static final byte[] FSC_TAB = DocWriter.getISOBytes((String)"\\tab ");
    private static final byte[] FSC_PAGE_PAR = DocWriter.getISOBytes((String)"\\page\\par ");
    private static final byte[] FSC_NEWPAGE = DocWriter.getISOBytes((String)"$newpage$");
    private static final byte[] FSC_BACKSLASH = DocWriter.getISOBytes((String)"\\");
    private static final byte[] FSC_HEX_PREFIX = DocWriter.getISOBytes((String)"\\'");
    private static final byte[] FSC_UNI_PREFIX = DocWriter.getISOBytes((String)"\\u");

    public RtfDocument() {
        super(null);
        this.documentHeader.init();
        this.previousRandomInts = new ArrayList();
        this.documentSettings = new RtfDocumentSettings(this);
    }

    @Override
    public void writeContent(OutputStream out) throws IOException {
    }

    public void writeDocument(OutputStream out) {
        try {
            out.write(OPEN_GROUP);
            out.write(RTF_DOCUMENT);
            this.documentHeader.writeContent(out);
            this.data.writeTo(out);
            out.write(CLOSE_GROUP);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void open() {
        try {
            switch (this.documentSettings.getDataCacheStyle()) {
                case 3: {
                    this.data = new RtfEfficientMemoryCache();
                    break;
                }
                case 2: {
                    this.data = new RtfMemoryCache();
                    break;
                }
                case 1: {
                    this.data = new RtfDiskCache();
                    break;
                }
                default: {
                    throw new RuntimeException(MessageLocalization.getComposedMessage((String)"unknown"));
                }
            }
        }
        catch (IOException ioe) {
            System.err.println("Could not initialize disk cache. Using memory cache.");
            ioe.printStackTrace();
            this.data = new RtfMemoryCache();
        }
    }

    public void add(RtfBasicElement element) {
        try {
            if (element instanceof RtfInfoElement) {
                this.documentHeader.addInfoElement((RtfInfoElement)element);
            } else {
                if (element instanceof RtfImage) {
                    ((RtfImage)element).setTopLevelElement(true);
                }
                element.writeContent(this.data.getOutputStream());
                this.lastElementWritten = element;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public RtfMapper getMapper() {
        return this.mapper;
    }

    public int getRandomInt() {
        Integer newInt = null;
        while (this.previousRandomInts.contains(newInt = new Integer((int)(Math.random() * 2.147483647E9)))) {
        }
        this.previousRandomInts.add(newInt);
        return newInt;
    }

    public RtfDocumentHeader getDocumentHeader() {
        return this.documentHeader;
    }

    public void filterSpecialChar(OutputStream out, String str, boolean useHex, boolean softLineBreaks) throws IOException {
        if (out == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage((String)"null.outpustream"));
        }
        boolean alwaysUseUniCode = this.documentSettings.isAlwaysUseUnicode();
        if (str == null) {
            return;
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        for (int k = 0; k < len; ++k) {
            char c = str.charAt(k);
            if (c < ' ') {
                if (c == '\n') {
                    out.write(softLineBreaks ? FSC_LINE : FSC_PAR);
                    continue;
                }
                if (c == '\t') {
                    out.write(FSC_TAB);
                    continue;
                }
                out.write(63);
                continue;
            }
            if (c == '\\' || c == '{' || c == '}') {
                out.write(FSC_BACKSLASH);
                out.write(c);
                continue;
            }
            if (c == '$' && len - k >= FSC_NEWPAGE.length && RtfDocument.subMatch(str, k, FSC_NEWPAGE)) {
                out.write(FSC_PAGE_PAR);
                k += FSC_NEWPAGE.length - 1;
                continue;
            }
            if (c > '\u00ff' || c > 'z' && alwaysUseUniCode) {
                if (useHex && c <= '\u00ff') {
                    out.write(FSC_HEX_PREFIX);
                    out.write(RtfImage.byte2charLUT, c * 2, 2);
                    continue;
                }
                out.write(FSC_UNI_PREFIX);
                String s = Short.toString((short)c);
                for (int x = 0; x < s.length(); ++x) {
                    out.write(s.charAt(x));
                }
                out.write(63);
                continue;
            }
            out.write(c);
        }
    }

    private static boolean subMatch(String str, int soff, byte[] m) {
        for (int k = 0; k < m.length; ++k) {
            if (str.charAt(soff++) == m[k]) continue;
            return false;
        }
        return true;
    }

    public void setAutogenerateTOCEntries(boolean autogenerate) {
        this.autogenerateTOCEntries = autogenerate;
    }

    public boolean getAutogenerateTOCEntries() {
        return this.autogenerateTOCEntries;
    }

    public RtfDocumentSettings getDocumentSettings() {
        return this.documentSettings;
    }

    public RtfBasicElement getLastElementWritten() {
        return this.lastElementWritten;
    }

    public final void outputDebugLinebreak(OutputStream result) throws IOException {
        if (this.getDocumentSettings().isOutputDebugLineBreaks()) {
            result.write(10);
        }
    }
}

