/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.url;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.rendition.url.DocumentRenditionCodec;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class RenditionBasedCodec
extends AbstractDocumentViewCodec {
    protected static final Log log = LogFactory.getLog(DocumentRenditionCodec.class);
    public static final int URL_MAX_LENGTH = 2000;
    public static final String RENDITION_PARAM_NAME = "rendition";
    public static final String RENDITION_VIEW_ID = "rendition";
    public static final String PATH_URL_PATTERN = "/([\\w\\.]+)(?:/(.*))?@([\\w\\-\\.\\%]+)/?(?:\\?(.*)?)?";
    public static final String ID_URL_PATTERN = "/(\\w+)/([a-zA-Z_0-9\\-]+)(/([\\w\\-\\.\\%]+))?(/)?(\\?(.*)?)?";

    public static String getRenditionUrl(DocumentModel doc, String renditionName) {
        DocumentViewImpl docView = new DocumentViewImpl(doc);
        docView.setViewId(renditionName);
        return new DocumentRenditionCodec().getUrlFromDocumentView((DocumentView)docView);
    }

    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pathPattern = Pattern.compile(this.getPrefix() + PATH_URL_PATTERN);
        Matcher pathMatcher = pathPattern.matcher(url);
        if (pathMatcher.matches()) {
            String server = pathMatcher.group(1);
            String path = pathMatcher.group(2);
            path = path != null ? "/" + URIUtils.unquoteURIPathComponent((String)path) : "/";
            PathRef docRef = new PathRef(path);
            String renditionName = URIUtils.unquoteURIPathComponent((String)pathMatcher.group(3));
            String query = pathMatcher.group(4);
            HashMap<String, String> params = URIUtils.getRequestParameters((String)query);
            if (params == null) {
                params = new HashMap<String, String>();
            }
            params.put("rendition", renditionName);
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            return new DocumentViewImpl((DocumentLocation)docLoc, "rendition", params);
        }
        Pattern idPattern = Pattern.compile(this.getPrefix() + ID_URL_PATTERN);
        Matcher idMatcher = idPattern.matcher(url);
        if (idMatcher.matches() && idMatcher.groupCount() >= 4) {
            String server = idMatcher.group(1);
            String uuid = idMatcher.group(2);
            IdRef docRef = new IdRef(uuid);
            String renditionName = URIUtils.unquoteURIPathComponent((String)idMatcher.group(4));
            Map<String, String> params = null;
            if (idMatcher.groupCount() > 6) {
                String query = idMatcher.group(7);
                params = URIUtils.getRequestParameters((String)query);
            }
            if (params == null) {
                params = new HashMap<String, String>();
            }
            params.put("rendition", renditionName);
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            return new DocumentViewImpl((DocumentLocation)docLoc, "rendition", params);
        }
        return null;
    }

    protected String getUrlFromDocumentViewWithId(DocumentView docView) {
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (docLoc != null) {
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(docLoc.getServerName());
            IdRef docRef = docLoc.getIdRef();
            if (docRef == null) {
                return null;
            }
            items.add(docRef.toString());
            String renditionName = docView.getParameter("rendition");
            if (StringUtils.isBlank((CharSequence)renditionName)) {
                renditionName = docView.getViewId();
            }
            if (renditionName != null) {
                items.add(URIUtils.quoteURIPathComponent((String)renditionName, (boolean)true));
            }
            String uri = StringUtils.join(items, (String)"/");
            HashMap params = new HashMap();
            Map dcparams = docView.getParameters();
            if (dcparams != null) {
                params.putAll(dcparams);
            }
            if (params != null && params.containsKey("rendition")) {
                params.remove("rendition");
            }
            return URIUtils.addParametersToURIQuery((String)uri, params);
        }
        return null;
    }

    public String getUrlFromDocumentView(DocumentView docView) {
        if ("true".equals(docView.getParameter("version")) && docView.getDocumentLocation().getIdRef() != null) {
            return this.getUrlFromDocumentViewWithId(docView);
        }
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (docLoc != null) {
            String uriWithParam;
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(docLoc.getServerName());
            PathRef docRef = docLoc.getPathRef();
            if (docRef == null) {
                return null;
            }
            String path = docRef.toString();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.length() > 0) {
                items.add(URIUtils.quoteURIPathComponent((String)path, (boolean)false));
            }
            String uri = StringUtils.join(items, (String)"/");
            String renditionName = docView.getParameter("rendition");
            if (StringUtils.isBlank((CharSequence)renditionName)) {
                renditionName = docView.getViewId();
            }
            if (renditionName != null) {
                uri = uri + "@" + URIUtils.quoteURIPathComponent((String)renditionName, (boolean)true);
            }
            HashMap params = new HashMap();
            Map dcparams = docView.getParameters();
            if (dcparams != null) {
                params.putAll(dcparams);
            }
            if (dcparams != null && dcparams.containsKey("rendition")) {
                params.remove("rendition");
            }
            if ((uriWithParam = URIUtils.addParametersToURIQuery((String)uri, params)).length() > 2000) {
                if (null == docView.getDocumentLocation().getIdRef()) {
                    log.error((Object)"The DocumentLocation did not contains the RefId.");
                    return uriWithParam;
                }
                return this.getUrlFromDocumentViewWithId(docView);
            }
            return uriWithParam;
        }
        return null;
    }
}

