/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.international.TimeZoneSelector;

@Scope(value=ScopeType.SESSION)
@Name(value="timeZones")
public class TimeZones
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In
    protected LocaleSelector localeSelector;
    private List<SelectItem> timeZoneSelectItems = null;

    public List<SelectItem> getTimeZones() {
        if (this.timeZoneSelectItems == null) {
            this.initTimeZones();
        }
        return this.timeZoneSelectItems;
    }

    public String displayCurrentTimeZone() {
        TimeZone timeZone;
        TimeZoneSelector tzs = TimeZoneSelector.instance();
        String timeZoneId = tzs.getTimeZoneId();
        if (StringUtils.isEmpty((CharSequence)timeZoneId) && (timeZone = tzs.getTimeZone()) != null) {
            timeZoneId = timeZone.getID();
        }
        return this.displayTimeZone(timeZoneId);
    }

    public String displayTimeZone(String id) {
        if (id == null || id.trim().length() == 0 || "none".equals(id)) {
            return "";
        }
        return id + " - " + TimeZone.getTimeZone(id).getDisplayName(this.localeSelector.getLocale());
    }

    private void initTimeZones() {
        String[] timeZoneIds;
        this.timeZoneSelectItems = new ArrayList<SelectItem>();
        for (String id : timeZoneIds = TimeZone.getAvailableIDs()) {
            this.timeZoneSelectItems.add(new SelectItem((Object)id, this.displayTimeZone(id)));
        }
        Collections.sort(this.timeZoneSelectItems, new Comparator<SelectItem>(){

            @Override
            public int compare(SelectItem o1, SelectItem o2) {
                return ((String)o1.getValue()).compareTo((String)o2.getValue());
            }
        });
    }
}

