/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree.nav;

import java.util.List;
import org.nuxeo.ecm.platform.actions.ActionService;
import org.nuxeo.ecm.webapp.directory.DirectoryTreeService;
import org.nuxeo.ecm.webapp.tree.nav.NavTreeDescriptor;
import org.nuxeo.ecm.webapp.tree.nav.NavTreeRegistry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class NavTreeService
extends DefaultComponent {
    public static final String NAVTREE_EP = "navigationTree";
    protected NavTreeRegistry registry;

    public void activate(ComponentContext context) {
        this.registry = new NavTreeRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.registry = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (NAVTREE_EP.equals(extensionPoint)) {
            NavTreeDescriptor contrib = (NavTreeDescriptor)contribution;
            this.registry.addContribution(contrib);
            this.getActionService().addAction(contrib.getAction());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (NAVTREE_EP.equals(extensionPoint)) {
            NavTreeDescriptor contrib = (NavTreeDescriptor)contribution;
            this.registry.removeContribution(contrib);
            this.getActionService().removeAction(contrib.getTreeId());
        }
    }

    public List<NavTreeDescriptor> getTreeDescriptors() {
        return this.registry.getTreeDescriptors(this.getDirectoryTreeService());
    }

    protected DirectoryTreeService getDirectoryTreeService() {
        return (DirectoryTreeService)((Object)Framework.getRuntime().getComponent(DirectoryTreeService.NAME));
    }

    protected ActionService getActionService() {
        return (ActionService)Framework.getRuntime().getComponent(ActionService.ID);
    }

    public Long getLastModified() {
        Long res = super.getLastModified();
        DirectoryTreeService treeService = this.getDirectoryTreeService();
        if (treeService != null) {
            Long other = treeService.getLastModified();
            if (res == null || other != null && other.compareTo(res) > 0) {
                res = other;
            }
        }
        return res;
    }
}

