/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;

public class DeleteDocumentRestlet
extends BaseStatelessNuxeoRestlet
implements LiveEditConstants {
    private static final Log log = LogFactory.getLog(DeleteDocumentRestlet.class);

    @Override
    protected void doHandleStatelessRequest(Request req, Response res) {
        boolean initOk;
        this.logDeprecation();
        String repoId = (String)req.getAttributes().get("repo");
        String docId = (String)req.getAttributes().get("docid");
        DOMDocumentFactory domFactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domFactory.createDocument();
        if (docId != null) {
            initOk = this.initRepositoryAndTargetDocument(res, repoId, docId);
            if (!initOk) {
                return;
            }
        } else {
            initOk = this.initRepository(res, repoId);
            if (!initOk) {
                return;
            }
            String path = DeleteDocumentRestlet.getQueryParamValue(req, "path", null);
            if (path == null) {
                return;
            }
            this.targetDocRef = new PathRef(path);
            try {
                this.targetDocument = this.session.getDocument(this.targetDocRef);
            }
            catch (NuxeoException e) {
                DeleteDocumentRestlet.handleError(result, res, "Unable to get document " + path);
                return;
            }
            docId = this.targetDocument.getId();
        }
        try {
            if (!this.session.canRemoveDocument(this.targetDocRef)) {
                DeleteDocumentRestlet.handleError(res, "This document can't be removed");
                return;
            }
            this.session.removeDocument(this.targetDocRef);
            this.session.save();
            Element docElement = result.addElement(documentTag);
            docElement.addElement(docRefTag).setText("Document " + docId + " deleted");
            res.setEntity(result.asXML(), MediaType.APPLICATION_XML);
            res.getEntity().setCharacterSet(CharacterSet.UTF_8);
        }
        catch (NuxeoException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            DeleteDocumentRestlet.handleError(res, (Exception)((Object)e));
        }
    }
}

