/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.jsf;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="operationActionBean")
@Scope(value=ScopeType.EVENT)
public class OperationActionBean
implements Serializable {
    private static final Log log = LogFactory.getLog(OperationActionBean.class);
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;

    public String doOperation(String chainId) throws OperationException {
        return this.runOperation(chainId);
    }

    protected void showError(OperationContext ctx, String chain, Throwable cause) {
        String msg = (String)ctx.get((Object)"Seam.AddErrorMessage");
        if (msg == null) {
            msg = "An error occured while executing the chain '" + chain + "': " + cause.getMessage();
        }
        this.facesMessages.add(StatusMessage.Severity.ERROR, msg, new Object[0]);
    }

    protected void showSuccess(OperationContext ctx, String chain) {
        String msg = (String)ctx.get((Object)"Seam.AddInfoMessage");
        if (msg != null) {
            this.facesMessages.add(StatusMessage.Severity.INFO, msg, new Object[0]);
        }
    }

    /*
     * Loose catch block
     */
    protected String runOperation(Object chain) throws OperationException {
        AutomationService os = (AutomationService)Framework.getService(AutomationService.class);
        Throwable throwable = null;
        try (OperationContext ctx = new OperationContext(this.documentManager);){
            block26: {
                ctx.setInput((Object)this.navigationContext.getCurrentDocument());
                if (!(chain instanceof String)) break block26;
                try {
                    os.run(ctx, (String)chain);
                    this.showSuccess(ctx, (String)chain);
                }
                catch (InvalidChainException e) {
                    this.facesMessages.add(StatusMessage.Severity.ERROR, "Unknown chain: " + chain, new Object[0]);
                    String string = null;
                    if (ctx != null) {
                        if (throwable != null) {
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            ctx.close();
                        }
                    }
                    return string;
                }
                catch (OperationException e) {
                    String string;
                    block24: {
                        block25: {
                            log.error((Object)"Failed to execute action: ", (Throwable)e);
                            Throwable cause = ExceptionHelper.unwrapException((Throwable)e);
                            this.showError(ctx, (String)chain, cause);
                            string = null;
                            if (ctx == null) break block24;
                            if (throwable == null) break block25;
                            try {
                                ctx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block24;
                        }
                        ctx.close();
                    }
                    return string;
                }
            }
            os.run(ctx, (OperationChain)chain);
            this.showSuccess(ctx, ((OperationChain)chain).getId());
            String string = (String)ctx.get((Object)"Outcome");
            return string;
            {
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
            }
        }
    }
}

