/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import javax.faces.model.SelectItem;
import org.apache.commons.lang3.StringUtils;

public class DirectorySelectItem
extends SelectItem {
    private static final long serialVersionUID = 1L;
    private String localizedLabel;
    private String displayedLabel;
    private long ordering;

    public DirectorySelectItem(Object value, String label) {
        this(value, label, 0L);
    }

    public DirectorySelectItem(Object value, String label, long ordering) {
        super(value, label);
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (label == null) {
            this.setLabel("");
        }
        try {
            this.ordering = ordering;
        }
        catch (NumberFormatException nfe) {
            this.ordering = 0L;
        }
    }

    public DirectorySelectItem(Object value, String label, long ordering, boolean disabled, boolean escape) {
        this(value, label, ordering);
        this.setDisabled(disabled);
        this.setEscape(escape);
    }

    @Deprecated
    public String getDisplayedLabel() {
        return this.displayedLabel;
    }

    @Deprecated
    public void setDisplayedLabel(String displayedLabel) {
        this.displayedLabel = displayedLabel;
    }

    @Deprecated
    public String getLocalizedLabel() {
        return this.localizedLabel;
    }

    @Deprecated
    public void setLocalizedLabel(String localizedLabel) {
        this.localizedLabel = localizedLabel;
    }

    public long getOrdering() {
        return this.ordering;
    }

    @Deprecated
    public String getSortLabel() {
        return StringUtils.isBlank((CharSequence)this.localizedLabel) ? this.displayedLabel : this.localizedLabel;
    }
}

