/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.validator;

import com.sun.faces.util.MessageFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.SortInfo;

public class SortInfoListValidator
implements Validator {
    public static final String VALIDATOR_ID = "SortInfoListValidator";
    public static final String INVALID_VALUE_MESSAGE_ID = "error.sortInfoValidator.invalidValue";
    public static final String CONFLICTING_CRITERIA_MESSAGE_ID = "error.sortInfoValidator.conflictingCriteria";
    public static final String EMPTY_CRITERION_MESSAGE_ID = "error.sortInfoValidator.emptyCriterion";

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new IllegalArgumentException();
        }
        if (value != null && value instanceof List) {
            try {
                List sortInfos = (List)value;
                ArrayList<String> criteria = new ArrayList<String>();
                for (Object sortInfo : sortInfos) {
                    String criterion = null;
                    if (sortInfo instanceof SortInfo) {
                        criterion = ((SortInfo)sortInfo).getSortColumn();
                    } else {
                        SortInfo sortInfoValue = SortInfo.asSortInfo((Map)((Map)sortInfo));
                        if (sortInfoValue == null) {
                            throw new ValidatorException(MessageFactory.getMessage((FacesContext)context, (String)INVALID_VALUE_MESSAGE_ID, (Object[])new Object[0]));
                        }
                        criterion = sortInfoValue.getSortColumn();
                    }
                    if (criterion == null || StringUtils.isEmpty((CharSequence)criterion.trim())) {
                        throw new ValidatorException(MessageFactory.getMessage((FacesContext)context, (String)EMPTY_CRITERION_MESSAGE_ID, (Object[])new Object[0]));
                    }
                    if (criteria.contains(criterion)) {
                        throw new ValidatorException(MessageFactory.getMessage((FacesContext)context, (String)CONFLICTING_CRITERIA_MESSAGE_ID, (Object[])new Object[]{criterion}));
                    }
                    criteria.add(criterion);
                }
            }
            catch (ClassCastException e) {
                throw new ValidatorException(MessageFactory.getMessage((FacesContext)context, (String)INVALID_VALUE_MESSAGE_ID, (Object[])new Object[0]));
            }
        }
    }
}

