/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Form;
import org.restlet.data.Method;

public class SystemLogRestlet
extends BaseStatelessNuxeoRestlet {
    private static final Log log = LogFactory.getLog(SystemLogRestlet.class);
    public static final String LEVEL = "level";
    public static final String MESSAGE = "message";
    public static final String TOKEN = "token";
    public static final String TOKEN_PROP = "org.nuxeo.systemlog.token";

    @Override
    protected void doHandleStatelessRequest(Request req, Response res) {
        if (Method.HEAD.equals((Object)req.getMethod())) {
            return;
        }
        Form form = req.getResourceRef().getQueryAsForm();
        String level = form.getFirstValue(LEVEL);
        String message = form.getFirstValue(MESSAGE);
        String token = form.getFirstValue(TOKEN);
        String tokenProp = Framework.getProperty((String)TOKEN_PROP);
        if (tokenProp == null || !tokenProp.equals(token)) {
            log.debug((Object)String.format("Provided token '%s' does not match %s", token, TOKEN_PROP));
        } else if ("error".equalsIgnoreCase(level)) {
            log.error((Object)message);
        } else if ("warn".equalsIgnoreCase(level)) {
            log.warn((Object)message);
        } else if ("info".equalsIgnoreCase(level)) {
            log.info((Object)message);
        } else if ("debug".equalsIgnoreCase(level)) {
            log.debug((Object)message);
        } else {
            log.trace((Object)message);
        }
    }
}

