/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.edit.lock;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="lockActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class LockActionsBean
implements LockActions {
    private static final long serialVersionUID = -8050964269646803077L;
    private static final Log log = LogFactory.getLog(LockActionsBean.class);
    private static final String EDIT_ACTIONS = "EDIT_ACTIONS";
    @In
    private transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    private Map<String, Serializable> lockDetails;
    private String documentId;

    @Override
    public Boolean getCanLockDoc(DocumentModel document) {
        boolean canLock;
        if (document == null) {
            log.warn((Object)"Can't evaluate lock action : currentDocument is null");
            canLock = false;
        } else if (document.isProxy()) {
            canLock = false;
        } else {
            NuxeoPrincipal userName = this.documentManager.getPrincipal();
            Lock lock = this.documentManager.getLockInfo(document.getRef());
            canLock = lock == null && (userName.isAdministrator() || this.isManagerOnDocument(document.getRef()) || this.documentManager.hasPermission(document.getRef(), "WriteProperties")) && !document.isVersion();
        }
        return canLock;
    }

    protected boolean isManagerOnDocument(DocumentRef ref) {
        return this.documentManager.hasPermission(ref, "Everything");
    }

    @Override
    @Factory(value="currentDocumentCanBeLocked", scope=ScopeType.EVENT)
    public Boolean getCanLockCurrentDoc() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getCanLockDoc(currentDocument);
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetEventContext() {
        Context evtCtx = Contexts.getEventContext();
        if (evtCtx != null) {
            evtCtx.remove("currentDocumentCanBeLocked");
            evtCtx.remove("currentDocumentLockDetails");
            evtCtx.remove("currentDocumentCanBeUnlocked");
        }
    }

    @Override
    public Boolean getCanUnlockDoc(DocumentModel document) {
        boolean canUnlock = false;
        if (document == null) {
            canUnlock = false;
        } else {
            NuxeoPrincipal userName = this.documentManager.getPrincipal();
            Map<String, Serializable> lockDetails = this.getLockDetails(document);
            canUnlock = lockDetails.isEmpty() || document.isProxy() ? false : (userName.isAdministrator() || this.documentManager.hasPermission(document.getRef(), "Everything") || userName.getName().equals(lockDetails.get("document.locker")) && this.documentManager.hasPermission(document.getRef(), "WriteProperties")) && !document.isVersion();
        }
        return canUnlock;
    }

    @Override
    @Factory(value="currentDocumentCanBeUnlocked", scope=ScopeType.EVENT)
    public Boolean getCanUnlockCurrentDoc() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getCanUnlockDoc(currentDocument);
    }

    @Override
    public String lockCurrentDocument() {
        String view = this.lockDocument(this.navigationContext.getCurrentDocument());
        this.navigationContext.invalidateCurrentDocument();
        return view;
    }

    @Override
    public String lockDocument(DocumentModel document) {
        log.debug((Object)"Lock a document ...");
        this.resetEventContext();
        String message = "document.lock.failed";
        DocumentRef ref = document.getRef();
        if (this.documentManager.hasPermission(ref, "WriteProperties") && this.documentManager.getLockInfo(ref) == null) {
            this.documentManager.setLock(ref);
            this.documentManager.save();
            message = "document.lock";
            Events.instance().raiseEvent("documentLocked", new Object[]{document});
            Events.instance().raiseEvent("documentChanged", new Object[]{document});
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(message), new Object[0]);
        this.resetLockState();
        this.webActions.resetTabList();
        return null;
    }

    @Override
    public String unlockCurrentDocument() {
        String view = this.unlockDocument(this.navigationContext.getCurrentDocument());
        this.navigationContext.invalidateCurrentDocument();
        return view;
    }

    @Override
    public String unlockDocument(DocumentModel document) {
        String message;
        log.debug((Object)"Unlock a document ...");
        this.resetEventContext();
        Map<String, Serializable> lockDetails = this.getLockDetails(document);
        if (lockDetails == null) {
            message = "document.unlock.done";
        } else {
            NuxeoPrincipal userName = this.documentManager.getPrincipal();
            if (userName.isAdministrator() || this.documentManager.hasPermission(document.getRef(), "Everything") || userName.getName().equals(lockDetails.get("document.locker"))) {
                if (!this.documentManager.hasPermission(document.getRef(), "WriteProperties")) {
                    new UnrestrictedUnlocker(document.getRef()).runUnrestricted();
                    this.documentManager.save();
                    message = "document.unlock";
                } else {
                    this.documentManager.removeLock(document.getRef());
                    this.documentManager.save();
                    message = "document.unlock";
                }
                Events.instance().raiseEvent("documentUnlocked", new Object[]{document});
                Events.instance().raiseEvent("documentChanged", new Object[]{document});
            } else {
                message = "document.unlock.not.permitted";
            }
        }
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(message), new Object[0]);
        this.resetLockState();
        this.webActions.resetTabList();
        return null;
    }

    @Override
    public Action getLockOrUnlockAction() {
        log.debug((Object)"Get lock or unlock action ...");
        Action lockOrUnlockAction = null;
        List actionsList = this.webActions.getActionsList(EDIT_ACTIONS);
        if (actionsList != null && !actionsList.isEmpty()) {
            lockOrUnlockAction = (Action)actionsList.get(0);
        }
        return lockOrUnlockAction;
    }

    @Override
    @Factory(value="currentDocumentLockDetails", scope=ScopeType.EVENT)
    public Map<String, Serializable> getCurrentDocLockDetails() {
        Map<String, Serializable> details = null;
        if (this.navigationContext.getCurrentDocument() != null) {
            details = this.getLockDetails(this.navigationContext.getCurrentDocument());
        }
        return details;
    }

    @Override
    public Map<String, Serializable> getLockDetails(DocumentModel document) {
        if (this.lockDetails == null || !StringUtils.equals((CharSequence)this.documentId, (CharSequence)document.getId())) {
            this.lockDetails = new HashMap<String, Serializable>();
            this.documentId = document.getId();
            Lock lock = this.documentManager.getLockInfo(document.getRef());
            if (lock == null) {
                return this.lockDetails;
            }
            this.lockDetails.put("document.locker", (Serializable)((Object)lock.getOwner()));
            this.lockDetails.put("document.lock.created", lock.getCreated());
        }
        return this.lockDetails;
    }

    @Override
    @BypassInterceptors
    public void resetLockState() {
        this.lockDetails = null;
        this.documentId = null;
    }

    protected class UnrestrictedUnlocker
    extends UnrestrictedSessionRunner {
        private final DocumentRef docRefToUnlock;

        protected UnrestrictedUnlocker(DocumentRef docRef) {
            super(LockActionsBean.this.documentManager);
            this.docRefToUnlock = docRef;
        }

        public void run() {
            this.session.removeLock(this.docRefToUnlock);
            this.session.save();
        }
    }
}

