/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.intranet.jenkins.web;

import com.nuxeo.intranet.jenkins.web.JenkinsJsonConverter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.model.EditableModel;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;

@Name(value="jenkinsJobsFetcher")
@Scope(value=ScopeType.EVENT)
public class JenkinsJobsFetcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JenkinsJobsFetcher.class);
    @RequestParameter
    protected String jenkinsURL;
    @RequestParameter
    protected String listComponentId;
    @RequestParameter
    protected String lastUpdateFeedbackComponentId;
    @RequestParameter
    protected String feedbackComponentId;
    @RequestParameter
    protected Boolean removeSuccessful;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true, required=false)
    protected DocumentActions documentActions;
    @In(create=true)
    protected NavigationContext navigationContext;

    public void fetchJobsToList(ActionEvent event) {
        if (this.jenkinsURL == null) {
            this.logMessage(StatusMessage.Severity.ERROR, "No URL sent to check Jenkins jobs");
            return;
        }
        try {
            UIComponent component = event.getComponent();
            if (component == null) {
                return;
            }
            UIEditableList list = (UIEditableList)ComponentUtils.getComponent((UIComponent)component, (String)this.listComponentId, UIEditableList.class);
            EditableValueHolder comment = (EditableValueHolder)ComponentUtils.getComponent((UIComponent)component, (String)this.lastUpdateFeedbackComponentId, EditableValueHolder.class);
            if (list != null) {
                String jsonURL = this.jenkinsURL.trim();
                if (!jsonURL.endsWith("/")) {
                    jsonURL = jsonURL + "/";
                }
                jsonURL = jsonURL + "api/json";
                JSONObject json = this.retrieveJSONObject(jsonURL);
                EditableModel em = list.getEditableModel();
                List oldData = (List)em.getWrappedData();
                JenkinsJsonConverter cv = new JenkinsJsonConverter();
                List<Map<String, Serializable>> jenkinsData = cv.convertJobs(json, oldData, this);
                List<Map<String, Serializable>> mergedData = cv.mergeData(oldData, jenkinsData);
                em.setWrappedData(mergedData);
                this.logMessage(StatusMessage.Severity.INFO, "Jobs retrieved from Jenkins, enjoy!");
                String updateMessage = this.computeLastUpdateFeedbackMessage(cv);
                if (comment != null) {
                    comment.setSubmittedValue((Object)updateMessage);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while retrieving jobs from Jenkins: %s", e.getMessage()));
        }
    }

    public void updateFromJenkins(ActionEvent event) {
        if (this.jenkinsURL == null) {
            this.logMessage(StatusMessage.Severity.ERROR, "No URL sent to check Jenkins jobs");
            return;
        }
        try {
            String jsonURL = this.jenkinsURL.trim();
            if (!jsonURL.endsWith("/")) {
                jsonURL = jsonURL + "/";
            }
            jsonURL = jsonURL + "api/json";
            JSONObject json = this.retrieveJSONObject(jsonURL);
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            List oldData = (List)((Object)currentDoc.getPropertyValue("jenkinsreport:unstable_jobs"));
            JenkinsJsonConverter cv = new JenkinsJsonConverter();
            List<Map<String, Serializable>> jenkinsData = cv.convertJobs(json, oldData, this);
            List<Map<String, Serializable>> mergedData = cv.mergeData(oldData, jenkinsData);
            currentDoc.setPropertyValue("jenkinsreport:unstable_jobs", (Serializable)((Object)mergedData));
            this.logMessage(StatusMessage.Severity.INFO, "Jobs retrieved from Jenkins, enjoy!");
            String updateMessage = this.computeLastUpdateFeedbackMessage(cv);
            currentDoc.setPropertyValue("jenkinsreport:last_update_feedback", (Serializable)((Object)updateMessage));
            this.documentActions.updateDocument(currentDoc, Boolean.TRUE);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while retrieving jobs from Jenkins: %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected JSONObject retrieveJSONObject(String url) {
        JSONObject jSONObject;
        BufferedReader in;
        block18: {
            JSONObject jsonObject;
            if (url == null) {
                return null;
            }
            in = null;
            HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
            conn.setInstanceFollowRedirects(true);
            int status = conn.getResponseCode();
            boolean redirect = false;
            if (status != 200 && (status == 302 || status == 301 || status == 303)) {
                redirect = true;
            }
            if (redirect) {
                String newUrl = conn.getHeaderField("Location");
                conn = (HttpURLConnection)new URL(newUrl).openConnection();
            }
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            IOUtils.copy((Reader)in, (OutputStream)output);
            jSONObject = jsonObject = JSONObject.fromObject((Object)output.toString());
            if (in == null) break block18;
            try {
                in.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
                this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while closing stream for url %s: %s", url, e.getMessage()));
            }
        }
        return jSONObject;
        catch (FileNotFoundException e) {
            JSONObject jSONObject2;
            block19: {
                jSONObject2 = null;
                if (in == null) break block19;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    log.error((Object)e2, (Throwable)e2);
                    this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while closing stream for url %s: %s", url, e2.getMessage()));
                }
            }
            return jSONObject2;
        }
        catch (IOException | JSONException e2) {
            JSONObject jSONObject3;
            block20: {
                log.error((Object)e2, e2);
                this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while retrieving jobs from Jenkins for url %s: %s", url, e2.getMessage()));
                jSONObject3 = null;
                if (in == null) break block20;
                {
                    catch (Throwable throwable) {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e3) {
                                log.error((Object)e3, (Throwable)e3);
                                this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while closing stream for url %s: %s", url, e3.getMessage()));
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e4) {
                    log.error((Object)e4, (Throwable)e4);
                    this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while closing stream for url %s: %s", url, e4.getMessage()));
                }
            }
            return jSONObject3;
        }
    }

    protected void logMessage(StatusMessage.Severity severity, String message) {
        this.facesMessages.addToControl(this.feedbackComponentId, severity, message, new Object[0]);
    }

    protected String computeLastUpdateFeedbackMessage(JenkinsJsonConverter converter) {
        StringBuilder res = new StringBuilder();
        res.append("Last Update done at ");
        DateFormat aDateFormat = DateFormat.getDateTimeInstance();
        res.append(aDateFormat.format(new Date()));
        res.append('\n');
        List messages = this.facesMessages.getCurrentMessagesForControl(this.feedbackComponentId);
        if (messages != null) {
            for (FacesMessage msg : messages) {
                if (msg.getSeverity().getOrdinal() > 0) {
                    res.append(msg.getSummary());
                    res.append('\n');
                    continue;
                }
                res.append("to remove: " + msg.getSummary());
                res.append('\n');
            }
        }
        if (converter != null) {
            res.append(String.format("Jobs retrieved from Jenkins: %s new failures, %s fixed, %s unchanged.", converter.getNewFailingCount(), converter.getFixedCount(), converter.getUnchangedCount()));
        }
        return res.toString();
    }
}

