/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.intranet.jenkins.web;

import com.nuxeo.intranet.jenkins.web.JenkinsJobsFetcher;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JenkinsJsonConverter {
    private static final Log log = LogFactory.getLog(JenkinsJsonConverter.class);
    protected int newFailingCount = 0;
    protected int fixedCount = 0;
    protected int stillUnstable = 0;
    protected int unchangedCount = 0;
    List<Map<String, Serializable>> mergedData = null;

    public List<Map<String, Serializable>> convertJobs(JSONObject jsonObject, List<Map<String, Serializable>> oldData, JenkinsJobsFetcher fetcher) throws IOException {
        JSONArray jsonJobs;
        ArrayList<Map<String, Serializable>> res = new ArrayList<Map<String, Serializable>>();
        ArrayList<String> retrievedJobs = new ArrayList<String>();
        if (jsonObject != null && (jsonJobs = jsonObject.optJSONArray("jobs")) != null) {
            for (Object jsonJob : jsonJobs) {
                String color = ((JSONObject)jsonJob).optString("color");
                if (color == null || color.startsWith("blue") || color.startsWith("grey") || color.startsWith("disabled")) continue;
                String url = ((JSONObject)jsonJob).getString("url");
                String jobId = ((JSONObject)jsonJob).getString("name");
                res.addAll(this.retrieveJobs(jobId, url, fetcher));
                retrievedJobs.add(jobId);
            }
        }
        if (oldData != null) {
            for (Map<String, Serializable> item : oldData) {
                String jobId = (String)((Object)item.get("job_id"));
                String url = (String)((Object)item.get("job_url"));
                if (retrievedJobs.contains(item.get("job_id"))) continue;
                res.addAll(this.retrieveJobs(jobId, url, fetcher));
            }
        }
        return res;
    }

    protected List<Map<String, Serializable>> retrieveJobs(String jobId, String url, JenkinsJobsFetcher fetcher) throws IOException {
        JSONObject jsonBuild;
        ArrayList<Map<String, Serializable>> res = new ArrayList<Map<String, Serializable>>();
        HashMap<String, Object> job = new HashMap<String, Object>();
        job.put("job_id", jobId);
        job.put("job_url", url);
        List<Map<String, Serializable>> subJobs = null;
        if (fetcher != null && url != null && (jsonBuild = fetcher.retrieveJSONObject(url.trim() + "lastCompletedBuild/api/json")) != null) {
            job.putAll(this.convertBuild(jsonBuild));
            subJobs = this.convertMultiOSDBJobs(jobId, jsonBuild, fetcher);
        }
        if (subJobs != null && !subJobs.isEmpty()) {
            res.addAll(subJobs);
        } else {
            res.add(job);
        }
        return res;
    }

    public List<Map<String, Serializable>> convertMultiOSDBJobs(String parentBuildId, JSONObject jsonParentBuild, JenkinsJobsFetcher fetcher) throws IOException {
        ArrayList<Map<String, Serializable>> res = new ArrayList<Map<String, Serializable>>();
        if (jsonParentBuild.containsKey((Object)"runs")) {
            JSONArray runs = jsonParentBuild.optJSONArray("runs");
            String parentBuildUrl = jsonParentBuild.getString("url");
            String parentUrl = this.removeBuildNumber(parentBuildUrl);
            if (runs != null) {
                for (Object jsonRun : runs) {
                    String runUrl;
                    if (jsonRun == null || !((JSONObject)jsonRun).has("url") || (runUrl = ((JSONObject)jsonRun).getString("url")) == null) continue;
                    HashMap<String, Object> runJob = new HashMap<String, Object>();
                    if (runUrl.startsWith(parentUrl)) {
                        String failureType;
                        JSONObject jsonRunBuild;
                        String runJobId = runUrl.substring(parentUrl.length());
                        runJobId = runJobId.substring(0, runJobId.indexOf("/"));
                        runJob.put("job_id", parentBuildId + "#" + runJobId);
                        String subUrl = this.removeBuildNumber(runUrl);
                        runJob.put("job_url", subUrl);
                        if (fetcher != null && (jsonRunBuild = fetcher.retrieveJSONObject(runUrl + "api/json")) != null) {
                            runJob.putAll(this.convertBuild(jsonRunBuild));
                        }
                        if ("SUCCESS".equals(failureType = (String)runJob.get("type"))) continue;
                        res.add(runJob);
                        continue;
                    }
                    log.warn((Object)("Ignoring failing job at " + runUrl));
                }
            }
        }
        return res;
    }

    protected String removeBuildNumber(String url) {
        String res = url;
        if (res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        res = res.substring(0, res.lastIndexOf("/") + 1);
        return res;
    }

    public Map<String, Serializable> convertBuild(JSONObject jsonBuild) throws IOException {
        String description;
        HashMap<String, Serializable> build = new HashMap<String, Serializable>();
        build.put("build_number", (Serializable)((Object)String.valueOf(jsonBuild.optInt("number"))));
        String comment = null;
        JSONArray actions = jsonBuild.optJSONArray("actions");
        if (actions != null) {
            for (Object jsonAction : actions) {
                if (jsonAction == null || !((JSONObject)jsonAction).has("claimed")) continue;
                JSONObject claim = (JSONObject)jsonAction;
                if (!claim.optBoolean("claimed")) break;
                build.put("claimer", (Serializable)((Object)claim.optString("claimedBy")));
                String reason = claim.optString("reason");
                if (this.isEmpty(reason)) break;
                comment = "Claim reason: " + reason;
                break;
            }
        }
        if (!this.isEmpty(description = jsonBuild.optString("description"))) {
            comment = comment != null ? comment + "\n\n" : "";
            comment = comment + "Description: " + description;
        }
        build.put("comment", (Serializable)((Object)comment));
        ArrayList<String> culprits = new ArrayList<String>();
        JSONArray jsonCulprits = jsonBuild.optJSONArray("culprits");
        if (jsonCulprits != null) {
            for (Object jsonCulprit : jsonCulprits) {
                String name;
                if (jsonCulprit == null || this.isEmpty(name = ((JSONObject)jsonCulprit).optString("fullName")) || "jenkins".equals(name)) continue;
                culprits.add(name);
            }
        }
        build.put("culprits", culprits);
        build.put("type", (Serializable)((Object)jsonBuild.optString("result")));
        return build;
    }

    public List<Map<String, Serializable>> mergeData(List<Map<String, Serializable>> oldData, List<Map<String, Serializable>> newData) {
        this.newFailingCount = 0;
        this.fixedCount = 0;
        this.unchangedCount = 0;
        this.mergedData = null;
        LinkedHashMap<String, Map<String, Serializable>> res = new LinkedHashMap<String, Map<String, Serializable>>();
        if (oldData != null) {
            for (Map<String, Serializable> item : oldData) {
                res.put((String)((Object)item.get("job_id")), item);
            }
        }
        if (newData != null) {
            for (Map<String, Serializable> item : newData) {
                String id = (String)((Object)item.get("job_id"));
                String build_number = (String)((Object)item.get("build_number"));
                if (res.containsKey(id)) {
                    Map oldItem = (Map)((HashMap)res).get(id);
                    String oldBuildNumber = String.valueOf(oldItem.get("build_number"));
                    if (build_number != null && build_number.equals(oldBuildNumber)) {
                        oldItem.put("claimer", item.get("claimer"));
                        oldItem.put("comment", item.get("comment"));
                        ++this.unchangedCount;
                    } else {
                        oldItem.put("updated_build_number", build_number);
                        String oldType = (String)oldItem.get("updated_type");
                        String newType = (String)((Object)item.get("type"));
                        oldItem.put("updated_type", newType);
                        oldItem.put("updated_comment", item.get("comment"));
                        oldItem.put("claimer", item.get("claimer"));
                        if ("SUCCESS".equals(newType) && !"SUCCESS".equals(oldType)) {
                            ++this.fixedCount;
                        }
                    }
                    res.put(id, oldItem);
                    continue;
                }
                if (oldData != null && !oldData.isEmpty()) {
                    item.put("newly_failing", (Serializable)((Object)"true"));
                }
                ++this.newFailingCount;
                res.put(id, item);
            }
        }
        this.unchangedCount = res.size() - (this.fixedCount + this.newFailingCount);
        this.mergedData = new ArrayList(((HashMap)res).values());
        return this.mergedData;
    }

    public int getNewFailingCount() {
        return this.newFailingCount;
    }

    public int getFixedCount() {
        return this.fixedCount;
    }

    public int getUnchangedCount() {
        return this.unchangedCount;
    }

    public List<Map<String, Serializable>> getMergedData() {
        return this.mergedData;
    }

    protected boolean isEmpty(String value) {
        return StringUtils.isBlank((String)value) || "null".equals(value);
    }
}

