/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo.intranet.jenkins.web;

import com.nuxeo.intranet.jenkins.web.JenkinsJsonConverter;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.impl.blob.URLBlob;
import org.nuxeo.ecm.platform.ui.web.component.list.UIEditableList;
import org.nuxeo.ecm.platform.ui.web.model.EditableModel;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="jenkinsJobsFetcher")
@Scope(value=ScopeType.EVENT)
public class JenkinsJobsFetcher
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(JenkinsJobsFetcher.class);
    @RequestParameter
    protected String jenkinsURL;
    @RequestParameter
    protected String listComponentId;
    @RequestParameter
    protected String feedbackComponentId;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;

    protected void logMessage(StatusMessage.Severity severity, String message) {
        this.facesMessages.addToControl(this.feedbackComponentId, severity, message, new Object[0]);
    }

    public void fetchJobsToList(ActionEvent event) {
        if (this.jenkinsURL == null) {
            this.facesMessages.addToControl(this.feedbackComponentId, StatusMessage.Severity.ERROR, "No URL sent to check Jenkins jobs", new Object[0]);
            return;
        }
        try {
            String jsonURL = this.jenkinsURL.trim();
            if (!jsonURL.endsWith("/")) {
                jsonURL = jsonURL + "/";
            }
            jsonURL = jsonURL + "api/json";
            JSONObject json = this.retrieveJSONObject(jsonURL);
            List<Map<String, Serializable>> jenkinsData = JenkinsJsonConverter.convertJobs(json, this);
            UIComponent component = event.getComponent();
            if (component == null) {
                return;
            }
            UIEditableList list = (UIEditableList)ComponentUtils.getComponent((UIComponent)component, (String)this.listComponentId, UIEditableList.class);
            if (list != null) {
                EditableModel em = list.getEditableModel();
                List oldData = (List)em.getWrappedData();
                em.setWrappedData(JenkinsJsonConverter.mergeData(oldData, jenkinsData));
            }
            this.facesMessages.addToControl(this.feedbackComponentId, StatusMessage.Severity.INFO, "Jobs retrieved from Jenkins, enjoy!", new Object[0]);
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.facesMessages.addToControl(this.feedbackComponentId, StatusMessage.Severity.ERROR, String.format("Error while retrieving jobs from Jenkins: %s", e.getMessage()), new Object[0]);
        }
    }

    protected JSONObject retrieveJSONObject(String url) {
        if (url == null) {
            return null;
        }
        try {
            if (url.startsWith("https")) {
                url = url.replaceFirst("https", "http");
            }
            URLBlob blob = new URLBlob(new URL(url), "application/json", "UTF-8", "content.json", null);
            String json = blob.getString();
            JSONObject jsonObject = JSONObject.fromObject((Object)json);
            return jsonObject;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            this.logMessage(StatusMessage.Severity.ERROR, String.format("Error while retrieving jobs from Jenkins for url %s: %s", url, e.getMessage()));
            return null;
        }
    }
}

