/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.action;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.action.MessageAction;

public class SendMailAction
implements MessageAction {
    private static final Log log = LogFactory.getLog(SendMailAction.class);
    protected final Session session;
    protected final String textMessage;

    public SendMailAction(Session session, String textMessage) {
        this.session = session;
        this.textMessage = textMessage;
    }

    @Override
    public boolean execute(ExecutionContext context) throws MessagingException {
        Message message = context.getMessage();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending mail because of message: " + message.getSubject()));
        }
        MimeMessage sentMessage = new MimeMessage(this.session);
        if (message.getReplyTo() == null || message.getReplyTo().length == 0) {
            return true;
        }
        Address address = message.getReplyTo()[0];
        sentMessage.setRecipient(Message.RecipientType.TO, address);
        message.setText(this.textMessage);
        Transport.send((Message)sentMessage);
        return true;
    }

    @Override
    public void reset(ExecutionContext context) {
    }
}

