/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mail.listener.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.platform.mail.action.ExecutionContext;
import org.nuxeo.ecm.platform.mail.listener.action.AbstractMailAction;

public class CheckMailUnicity
extends AbstractMailAction {
    private static final Log log = LogFactory.getLog(CheckMailUnicity.class);
    public static final String MAIL_SEARCH_QUERY = "SELECT * FROM MailMessage WHERE mail:messageId = %s AND ecm:path STARTSWITH %s AND ecm:isProxy = 0 ";

    @Override
    public boolean execute(ExecutionContext context) {
        CoreSession session = this.getCoreSession(context);
        if (session == null) {
            log.error((Object)"Could not open CoreSession");
            return false;
        }
        ExecutionContext initialContext = context.getInitialContext();
        Path parentPath = new Path((String)initialContext.get("parentPath"));
        String messageId = (String)context.get("messageId");
        StringBuilder query = new StringBuilder();
        query.append(String.format(MAIL_SEARCH_QUERY, NXQL.escapeString((String)messageId), NXQL.escapeString((String)parentPath.toString())));
        DocumentModelList duplicatedMail = session.query(query.toString());
        return duplicatedMail.isEmpty();
    }
}

