/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.generative.ai;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.generative.ai.GenerativeAI;
import org.nuxeo.generative.ai.GenerativeAIDescriptor;
import org.nuxeo.generative.ai.GenerativeAIProvider;
import org.nuxeo.generative.ai.GenerativeAIProviderDescriptor;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class GenerativeAIImpl
extends DefaultComponent
implements GenerativeAI {
    private static final Log log = LogFactory.getLog(GenerativeAIImpl.class);
    protected static final String CONFIG_EXT_POINT = "configuration";
    protected static final String PROVIDER_EXT_POINT = "provider";
    protected GenerativeAIDescriptor config = null;
    protected Map<String, GenerativeAIProvider> providers = new HashMap<String, GenerativeAIProvider>();

    public void registerExtension(Extension extension) {
        super.registerExtension(extension);
        Object[] contribs = extension.getContributions();
        if (contribs == null || contribs.length == 0) {
            log.warn((Object)("No contribution for the '" + extension.getExtensionPoint() + "' extension point => calls to generative AI will fail."));
            return;
        }
        switch (extension.getExtensionPoint()) {
            case "configuration": {
                this.config = (GenerativeAIDescriptor)contribs[0];
                break;
            }
            case "provider": {
                for (Object contrib : contribs) {
                    GenerativeAIProviderDescriptor providerDesc = (GenerativeAIProviderDescriptor)contrib;
                    try {
                        GenerativeAIProvider provider = (GenerativeAIProvider)providerDesc.getKlass().getConstructor(GenerativeAIProviderDescriptor.class).newInstance(providerDesc);
                        this.providers.put(providerDesc.name, provider);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new NuxeoException((Throwable)e);
                    }
                }
                break;
            }
        }
    }

    @Override
    public GenerativeAIProvider getProvider(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "openai";
        }
        return this.providers.get(name);
    }

    @Override
    public Blob generateImage(String provider, String prompt, String size) throws IOException {
        GenerativeAIProvider aiProvider = this.getProviderOrDefault(provider);
        return aiProvider.generateImage(prompt, size);
    }

    protected GenerativeAIProvider getProviderOrDefault(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "openai";
        }
        return this.getProvider(name);
    }
}

