/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.generative.operations;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.generative.ai.GenerativeAI;
import org.nuxeo.runtime.api.Framework;

@Operation(id="GenerativeAi.GenerateImage", category="GenerativeAi", label="Generate an image", description="Generate an image based on given conditions")
public class GenerateImageOperation {
    public static final String ID = "GenerativeAi.GenerateImage";
    private static final Log log = LogFactory.getLog(GenerateImageOperation.class);
    @Param(name="prompt")
    protected String prompt;
    @Param(name="style", required=false)
    protected String[] style;

    @OperationMethod
    public Blob run() {
        try {
            Blob result = ((GenerativeAI)Framework.getService(GenerativeAI.class)).generateImage(null, this.combineParameters(this.prompt, this.style), "1024x1024");
            if (result != null) {
                BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
                String batchId = bm.initBatch();
                Batch batch = bm.getBatch(batchId);
                batch.addFile("0", result, result.getFilename(), result.getMimeType());
                return new StringBlob(this.toJson(result.getFilename(), batchId, result).toString(), "application/json");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            return new StringBlob(this.messageToJson(e.getMessage()).toString(), "application/json");
        }
        return new StringBlob(this.messageToJson("No image generated, please try again").toString(), "application/json");
    }

    private String combineParameters(String prompt, String[] style) {
        StringBuilder combined = new StringBuilder();
        if (prompt != null) {
            combined.append(prompt);
        }
        if (style != null) {
            String styles = Arrays.stream(style).map(x -> x + " style").collect(Collectors.joining(" and "));
            combined.append(" in a ").append(styles);
        }
        return combined.toString().trim();
    }

    private JSONObject toJson(String title, String batchId, Blob image) throws JSONException, IOException {
        JSONObject json = new JSONObject();
        json.put("title", (Object)title);
        json.put("batchId", (Object)batchId);
        json.put("content", (Object)Base64.getEncoder().encodeToString(image.getByteArray()));
        return json;
    }

    private JSONObject messageToJson(String message) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("message", (Object)message);
        return json;
    }
}

