/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.generative.ai;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public interface GenerativeAIProvider {
    public static final String IMG_256 = "256x256";
    public static final String IMG_512 = "512x512";
    public static final String IMG_1024 = "1024x1024";

    public String getName();

    public Blob generateImage(String var1, String var2) throws IOException;

    public static Blob downloadFile(String urlStr, String fileName, String provider) throws IOException {
        Blob result = Blobs.createBlobWithExtension((String)".tmp");
        File resultFile = result.getFile();
        URL url = new URL(urlStr);
        try (InputStream in = url.openStream();
             ReadableByteChannel rbc = Channels.newChannel(in);
             FileOutputStream fos = new FileOutputStream(resultFile.getAbsolutePath());){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            URLConnection connection = url.openConnection();
            String mimeType = connection.getContentType();
            result.setMimeType(mimeType);
            MimetypeRegistry mimetypeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
            List exts = mimetypeService.getExtensionsFromMimetypeName(mimeType);
            String ext = "";
            if (exts.size() > 0) {
                ext = (String)exts.get(0);
            }
            if (StringUtils.isBlank((CharSequence)fileName)) {
                fileName = StringUtils.isBlank((CharSequence)provider) ? "nuxeo-generative-ai-" : provider + "-";
                String formattedDateTime = DateFormatUtils.format((long)System.currentTimeMillis(), (String)"yyyy-MM-dd-HHhmm");
                fileName = (String)fileName + formattedDateTime;
            }
            fileName = (String)fileName + "." + ext;
            result.setFilename((String)fileName);
        }
        return result;
    }
}

