/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.disposables;

import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import java.util.concurrent.atomic.AtomicReference;

abstract class ReferenceDisposable<T>
extends AtomicReference<T>
implements Disposable {
    private static final long serialVersionUID = 6537757548749041217L;

    ReferenceDisposable(T value) {
        super(ObjectHelper.requireNonNull(value, "value is null"));
    }

    protected abstract void onDisposed(T var1);

    @Override
    public final void dispose() {
        Object value = this.get();
        if (value != null && (value = this.getAndSet(null)) != null) {
            this.onDisposed(value);
        }
    }

    @Override
    public final boolean isDisposed() {
        return this.get() == null;
    }
}

