/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.provider;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;

public class ElasticSearchNxqlPageProvider
extends CoreQueryDocumentPageProvider {
    public static final String CORE_SESSION_PROPERTY = "coreSession";
    public static final String SEARCH_ON_ALL_REPOSITORIES_PROPERTY = "searchAllRepositories";
    protected static final Log log = LogFactory.getLog(ElasticSearchNxqlPageProvider.class);
    private static final long serialVersionUID = 1L;
    protected List<DocumentModel> currentPageDocuments;

    public List<DocumentModel> getCurrentPage() {
        if (this.currentPageDocuments != null) {
            return this.currentPageDocuments;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Perform query for provider '%s': with pageSize=%d, offset=%d", this.getName(), this.getMinMaxPageSize(), this.getCurrentPageOffset()));
        }
        CoreSession coreSession = this.getCoreSession();
        if (this.query == null) {
            this.buildQuery(coreSession);
        }
        if (this.query == null) {
            throw new ClientRuntimeException(String.format("Cannot perform null query: check provider '%s'", this.getName()));
        }
        ElasticSearchService ess = (ElasticSearchService)Framework.getLocalService(ElasticSearchService.class);
        try {
            NxQueryBuilder nxQuery = new NxQueryBuilder(this.getCoreSession()).nxql(this.query).offset((int)this.getCurrentPageOffset()).limit((int)this.getMinMaxPageSize());
            if (this.searchOnAllRepositories()) {
                nxQuery.searchOnAllRepositories();
            }
            DocumentModelList dmList = ess.query(nxQuery);
            this.setResultsCount(dmList.totalSize());
            this.currentPageDocuments = dmList;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return this.currentPageDocuments;
    }

    public QueryBuilder getCurrentQueryAsEsBuilder() {
        String nxql = this.getCurrentQuery();
        return NxqlQueryConverter.toESQueryBuilder(nxql);
    }

    protected void pageChanged() {
        this.currentPageDocuments = null;
        super.pageChanged();
    }

    public void refresh() {
        this.currentPageDocuments = null;
        super.refresh();
    }

    protected CoreSession getCoreSession() {
        Map props = this.getProperties();
        CoreSession coreSession = (CoreSession)props.get(CORE_SESSION_PROPERTY);
        if (coreSession == null) {
            throw new ClientRuntimeException("cannot find core session");
        }
        return coreSession;
    }

    protected boolean searchOnAllRepositories() {
        String value = (String)this.getProperties().get(SEARCH_ON_ALL_REPOSITORIES_PROPERTY);
        if (value == null) {
            return false;
        }
        return Boolean.valueOf(value);
    }
}

