/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.text.BytesText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;

public class StringTerms
extends InternalTerms {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("terms", "sterms");
    public static AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public StringTerms readResult(StreamInput in) throws IOException {
            StringTerms buckets = new StringTerms();
            buckets.readFrom(in);
            return buckets;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    StringTerms() {
    }

    public StringTerms(String name, InternalOrder order, int requiredSize, long minDocCount, Collection<InternalTerms.Bucket> buckets) {
        super(name, order, requiredSize, minDocCount, buckets);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.order = InternalOrder.Streams.readOrder(in);
        this.requiredSize = StringTerms.readSize(in);
        this.minDocCount = in.readVLong();
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            buckets.add(new Bucket(in.readBytesRef(), in.readVLong(), InternalAggregations.readAggregations(in)));
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        InternalOrder.Streams.writeOrder(this.order, out);
        StringTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        out.writeVInt(this.buckets.size());
        for (InternalTerms.Bucket bucket : this.buckets) {
            out.writeBytesRef(((Bucket)bucket).termBytes);
            out.writeVLong(bucket.getDocCount());
            ((InternalAggregations)bucket.getAggregations()).writeTo(out);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        for (InternalTerms.Bucket bucket : this.buckets) {
            builder.startObject();
            builder.field(InternalAggregation.CommonFields.KEY, ((Bucket)bucket).termBytes);
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, bucket.getDocCount());
            ((InternalAggregations)bucket.getAggregations()).toXContentInternal(builder, params);
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static class Bucket
    extends InternalTerms.Bucket {
        BytesRef termBytes;

        public Bucket(BytesRef term, long docCount, InternalAggregations aggregations) {
            super(docCount, aggregations);
            this.termBytes = term;
        }

        @Override
        public String getKey() {
            return this.termBytes.utf8ToString();
        }

        @Override
        public Text getKeyAsText() {
            return new BytesText(new BytesArray(this.termBytes));
        }

        @Override
        public Number getKeyAsNumber() {
            return Double.parseDouble(this.termBytes.utf8ToString());
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return BytesRef.getUTF8SortedAsUnicodeComparator().compare(this.termBytes, ((Bucket)other).termBytes);
        }
    }
}

