/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexComponent;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.fielddata.breaker.CircuitBreakerService;

public interface IndexFieldData<FD extends AtomicFieldData>
extends IndexComponent {
    public FieldMapper.Names getFieldNames();

    public boolean valuesOrdered();

    public FD load(AtomicReaderContext var1);

    public FD loadDirect(AtomicReaderContext var1) throws Exception;

    public XFieldComparatorSource comparatorSource(@Nullable Object var1, SortMode var2);

    public void clear();

    public void clear(IndexReader var1);

    public static interface WithOrdinals<FD extends AtomicFieldData.WithOrdinals>
    extends IndexFieldData<FD> {
        @Override
        public FD load(AtomicReaderContext var1);

        @Override
        public FD loadDirect(AtomicReaderContext var1) throws Exception;
    }

    public static interface Builder {
        public IndexFieldData build(Index var1, @IndexSettings Settings var2, FieldMapper<?> var3, IndexFieldDataCache var4, CircuitBreakerService var5, MapperService var6);
    }

    public static abstract class XFieldComparatorSource
    extends FieldComparatorSource {
        public static final BytesRef MAX_TERM = new BytesRef();

        protected final boolean sortMissingFirst(Object missingValue) {
            return "_first".equals(missingValue);
        }

        protected final boolean sortMissingLast(Object missingValue) {
            return missingValue == null || "_last".equals(missingValue);
        }

        protected final Object missingObject(Object missingValue, boolean reversed) {
            if (this.sortMissingFirst(missingValue) || this.sortMissingLast(missingValue)) {
                boolean min = this.sortMissingFirst(missingValue) ^ reversed;
                switch (this.reducedType()) {
                    case INT: {
                        return min ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                    }
                    case LONG: {
                        return min ? Long.MIN_VALUE : Long.MAX_VALUE;
                    }
                    case FLOAT: {
                        return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                    }
                    case DOUBLE: {
                        return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    case STRING: 
                    case STRING_VAL: {
                        return min ? null : MAX_TERM;
                    }
                }
                throw new UnsupportedOperationException("Unsupported reduced type: " + this.reducedType());
            }
            switch (this.reducedType()) {
                case INT: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).intValue();
                    }
                    return Integer.parseInt(missingValue.toString());
                }
                case LONG: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).longValue();
                    }
                    return Long.parseLong(missingValue.toString());
                }
                case FLOAT: {
                    if (missingValue instanceof Number) {
                        return Float.valueOf(((Number)missingValue).floatValue());
                    }
                    return Float.valueOf(Float.parseFloat(missingValue.toString()));
                }
                case DOUBLE: {
                    if (missingValue instanceof Number) {
                        return ((Number)missingValue).doubleValue();
                    }
                    return Double.parseDouble(missingValue.toString());
                }
                case STRING: 
                case STRING_VAL: {
                    if (missingValue instanceof BytesRef) {
                        return (BytesRef)missingValue;
                    }
                    if (missingValue instanceof byte[]) {
                        return new BytesRef((byte[])missingValue);
                    }
                    return new BytesRef((CharSequence)missingValue.toString());
                }
            }
            throw new UnsupportedOperationException("Unsupported reduced type: " + this.reducedType());
        }

        public abstract SortField.Type reducedType();

        static {
            char[] chars = Character.toChars(0x10FFFF);
            UnicodeUtil.UTF16toUTF8((char[])chars, (int)0, (int)chars.length, (BytesRef)MAX_TERM);
        }
    }

    public static class CommonSettings {
        public static boolean removeOrdsOnSingleValue(FieldDataType fieldDataType) {
            return !"always".equals(fieldDataType.getSettings().get("ordinals"));
        }
    }
}

