/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.work.AbstractIndexingWorker;
import org.nuxeo.runtime.api.Framework;

public class ChildrenIndexingWorker
extends AbstractIndexingWorker
implements Work {
    private static final int LIMIT = 50;
    private static final long serialVersionUID = 1L;
    private static final String QUERY = "SELECT * FROM Document WHERE ecm:parentId = '%s' ORDER BY dc:created ASC";

    public ChildrenIndexingWorker(IndexingCommand cmd) {
        super(cmd);
    }

    public String getTitle() {
        String title = " ElasticSearch indexing children for doc " + this.cmd.getDocId() + " in repository " + this.cmd.getRepository();
        if (this.path != null) {
            title = title + " (" + this.path + ")";
        }
        return title;
    }

    @Override
    protected void doIndexingWork(ElasticSearchIndexing esi, IndexingCommand cmd) throws Exception {
        DocumentModel doc = cmd.getTargetDocument();
        long offset = 0L;
        DocumentModelList documentsToBeIndexed = this.session.query(String.format(QUERY, doc.getRef()), null, 50L, offset, false);
        while (documentsToBeIndexed != null && !documentsToBeIndexed.isEmpty()) {
            this.session.save();
            for (DocumentModel child : documentsToBeIndexed) {
                IndexingCommand childCommand = cmd.clone(child);
                if (!esi.isAlreadyScheduled(childCommand)) {
                    esi.indexNow(childCommand);
                }
                if (!child.isFolder()) continue;
                ChildrenIndexingWorker subWorker = new ChildrenIndexingWorker(childCommand);
                WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
                wm.schedule((Work)subWorker);
            }
            if (documentsToBeIndexed.size() < 50) break;
            documentsToBeIndexed = this.session.query(String.format(QUERY, doc.getRef()), null, 50L, offset += 50L, false);
        }
    }
}

