/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.io;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.search.lookup.SourceLookup;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;

public class JsonDocumentModelReader {
    private static final Log log = LogFactory.getLog(JsonDocumentModelReader.class);
    private final Map<String, Object> source;
    private String sid;

    public JsonDocumentModelReader(String json) {
        byte[] bytes = json.getBytes();
        this.source = SourceLookup.sourceAsMap((BytesReference)new BytesArray(bytes, 0, bytes.length));
    }

    public JsonDocumentModelReader(Map<String, Object> source) {
        this.source = source;
    }

    public JsonDocumentModelReader session(CoreSession session) {
        this.sid = session.getSessionId();
        return this;
    }

    public JsonDocumentModelReader sid(String sid) {
        this.sid = sid;
        return this;
    }

    public DocumentModel getDocumentModel() {
        assert (this.source != null);
        String type = this.getType();
        String name = this.getPropertyAsString("ecm:name");
        String id = this.getPropertyAsString("ecm:uuid");
        String path = this.getPropertyAsString("ecm:path");
        String parentId = this.getPropertyAsString("ecm:parentId");
        String repository = this.getPropertyAsString("ecm:repository");
        DocumentModelImpl doc = new DocumentModelImpl(this.sid, this.getType(), id, new Path(path), (DocumentRef)new IdRef(id), (DocumentRef)new IdRef(parentId), null, null, null, repository, false);
        for (String prop : this.source.keySet()) {
            String value;
            String schema = prop.split(":")[0];
            String key = prop.split(":")[1];
            if (this.source.get(prop) == null || (value = this.getPropertyAsString(prop)).isEmpty() || "[]".equals(value)) continue;
            if ("ecm".equals(schema)) {
                switch (key) {
                    case "isProxy": {
                        doc.setIsProxy(Boolean.valueOf(value).booleanValue());
                        break;
                    }
                    case "currentLifeCycleState": {
                        doc.prefetchCurrentLifecycleState(value);
                        break;
                    }
                    case "versionLabel": 
                    case "mixinType": {
                        break;
                    }
                }
                continue;
            }
            try {
                doc.setPropertyValue(prop, (Serializable)((Object)value));
            }
            catch (ClientException e) {
                log.info((Object)String.format("fetchDocFromEs can not set property %s to %s", key, value));
            }
        }
        doc.setIsImmutable(true);
        return doc;
    }

    private String getType() {
        return this.getPropertyAsString("ecm:primaryType");
    }

    private String getPropertyAsString(String name) {
        Object prop = this.source.get(name);
        return prop == null ? "" : prop.toString();
    }
}

