/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.web.admin;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.elasticsearch.web.admin.ContentViewStatus;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

@Name(value="esAdmin")
@Scope(value=ScopeType.EVENT)
public class ElasticSearchManager {
    private static final Log log = LogFactory.getLog(ElasticSearchManager.class);
    @In(create=true)
    protected ElasticSearchAdmin esa;
    @In(create=true)
    protected ElasticSearchIndexing esi;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    protected List<ContentViewStatus> cvStatuses = null;
    protected Timer indexTimer;
    private String rootId;

    public String getNodesInfo() {
        NodesInfoResponse nodesInfo = (NodesInfoResponse)this.esa.getClient().admin().cluster().prepareNodesInfo(new String[0]).execute().actionGet();
        return nodesInfo.toString();
    }

    public String getNodesStats() {
        NodesStatsResponse stats = (NodesStatsResponse)this.esa.getClient().admin().cluster().prepareNodesStats(new String[0]).execute().actionGet();
        return stats.toString();
    }

    public String getNodesHealth() {
        ClusterHealthResponse health = (ClusterHealthResponse)this.esa.getClient().admin().cluster().prepareHealth(new String[0]).execute().actionGet();
        return health.toString();
    }

    public void startReindex() throws Exception {
        log.warn((Object)"Start re-indexing repository");
        IndexingCommand cmd = new IndexingCommand(this.documentManager.getRootDocument(), false, true);
        this.esi.scheduleIndexing(cmd);
    }

    public void startReindexFrom() throws Exception {
        if (this.rootId == null) {
            this.startReindex();
            return;
        }
        log.warn((Object)String.format("Start re-indexing from %s repository", this.rootId));
        IndexingCommand cmd = new IndexingCommand(this.documentManager.getDocument((DocumentRef)new IdRef(this.rootId)), false, true);
        this.esi.scheduleIndexing(cmd);
    }

    public void flush() {
        this.esa.flush();
    }

    protected void introspectPageProviders() throws Exception {
        this.cvStatuses = new ArrayList<ContentViewStatus>();
        ContentViewService cvs = (ContentViewService)Framework.getLocalService(ContentViewService.class);
        for (String cvName : cvs.getContentViewNames()) {
            ContentView cv = cvs.getContentView(cvName);
            PageProviderDefinition def = cv.getPageProvider().getDefinition();
            if (def instanceof GenericPageProviderDescriptor) {
                GenericPageProviderDescriptor gppd = (GenericPageProviderDescriptor)def;
                if (gppd.getPageProviderClass().getName().contains("elasticsearch")) {
                    this.cvStatuses.add(new ContentViewStatus(cvName, gppd.getName(), "elasticsearch"));
                    continue;
                }
                this.cvStatuses.add(new ContentViewStatus(cvName, gppd.getName(), gppd.getPageProviderClass().getName()));
                continue;
            }
            if (!(def instanceof CoreQueryPageProviderDescriptor)) continue;
            this.cvStatuses.add(new ContentViewStatus(cvName, def.getName(), "core"));
        }
        Collections.sort(this.cvStatuses);
    }

    public List<ContentViewStatus> getContentViewStatus() throws Exception {
        if (this.cvStatuses == null) {
            this.introspectPageProviders();
        }
        return this.cvStatuses;
    }

    public Boolean isIndexingInProgress() {
        return this.esa.isIndexingInProgress();
    }

    public String getPendingCommands() {
        return Integer.valueOf(this.esa.getPendingCommands()).toString();
    }

    public String getRunningCommands() {
        return Integer.valueOf(this.esa.getRunningCommands()).toString();
    }

    public String getTotalCommandProcessed() {
        return Integer.valueOf(this.esa.getTotalCommandProcessed()).toString();
    }

    public String getNumberOfDocuments() {
        NodesStatsResponse stats = (NodesStatsResponse)this.esa.getClient().admin().cluster().prepareNodesStats(new String[0]).execute().actionGet();
        return Long.valueOf(((NodeStats[])stats.getNodes())[0].getIndices().getDocs().getCount()).toString();
    }

    public String getNumberOfDeletedDocuments() {
        NodesStatsResponse stats = (NodesStatsResponse)this.esa.getClient().admin().cluster().prepareNodesStats(new String[0]).execute().actionGet();
        return Long.valueOf(((NodeStats[])stats.getNodes())[0].getIndices().getDocs().getDeleted()).toString();
    }

    public String getIndexingRates() {
        if (this.indexTimer == null) {
            MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
            this.indexTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "index"}));
        }
        return String.format("%.2f, %.2f, %.2f", this.indexTimer.getOneMinuteRate(), this.indexTimer.getFiveMinuteRate(), this.indexTimer.getFifteenMinuteRate());
    }

    public String getRootId() {
        return this.rootId;
    }

    public void setRootId(String rootId) {
        this.rootId = rootId;
    }
}

