/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.mapper.Uid;

final class ParentIdsFilter
extends Filter {
    private final BytesRef parentTypeBr;
    private final Filter nonNestedDocsFilter;
    private final BytesRefHash parentIds;

    ParentIdsFilter(String parentType, Filter nonNestedDocsFilter, BytesRefHash parentIds) {
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        this.parentTypeBr = new BytesRef((CharSequence)parentType);
        this.parentIds = parentIds;
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        Terms terms = context.reader().terms("_uid");
        if (terms == null) {
            return null;
        }
        TermsEnum termsEnum = terms.iterator(null);
        BytesRef uidSpare = new BytesRef();
        BytesRef idSpare = new BytesRef();
        if (acceptDocs == null) {
            acceptDocs = context.reader().getLiveDocs();
        }
        FixedBitSet nonNestedDocs = null;
        if (this.nonNestedDocsFilter != null) {
            nonNestedDocs = (FixedBitSet)this.nonNestedDocsFilter.getDocIdSet(context, acceptDocs);
        }
        DocsEnum docsEnum = null;
        FixedBitSet result = null;
        long size = this.parentIds.size();
        int i = 0;
        while ((long)i < size) {
            block9: {
                int docId;
                block11: {
                    block10: {
                        this.parentIds.get(i, idSpare);
                        Uid.createUidAsBytes(this.parentTypeBr, idSpare, uidSpare);
                        if (!termsEnum.seekExact(uidSpare)) break block9;
                        docsEnum = termsEnum.docs(acceptDocs, docsEnum, 0);
                        if (result != null) break block10;
                        docId = docsEnum.nextDoc();
                        if (docId == Integer.MAX_VALUE) break block9;
                        result = new FixedBitSet(context.reader().maxDoc());
                        break block11;
                    }
                    docId = docsEnum.nextDoc();
                    if (docId == Integer.MAX_VALUE) break block9;
                }
                if (nonNestedDocs != null && !nonNestedDocs.get(docId)) {
                    docId = nonNestedDocs.nextSetBit(docId);
                }
                result.set(docId);
                assert (docsEnum.advance(docId + 1) == Integer.MAX_VALUE) : "DocId " + docId + " should have been the last one but docId " + docsEnum.docID() + " exists.";
            }
            ++i;
        }
        return result;
    }
}

