/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.index.mapper.FieldMapper;

public class FieldMappers
implements Iterable<FieldMapper> {
    private final FieldMapper[] fieldMappers;
    private final List<FieldMapper> fieldMappersAsList;

    public FieldMappers() {
        this.fieldMappers = new FieldMapper[0];
        this.fieldMappersAsList = Arrays.asList(this.fieldMappers);
    }

    public FieldMappers(FieldMapper fieldMapper) {
        this.fieldMappers = new FieldMapper[]{fieldMapper};
        this.fieldMappersAsList = Arrays.asList(this.fieldMappers);
    }

    private FieldMappers(FieldMapper[] fieldMappers) {
        this.fieldMappers = fieldMappers;
        this.fieldMappersAsList = Arrays.asList(this.fieldMappers);
    }

    public FieldMapper mapper() {
        if (this.fieldMappers.length == 0) {
            return null;
        }
        return this.fieldMappers[0];
    }

    public boolean isEmpty() {
        return this.fieldMappers.length == 0;
    }

    public List<FieldMapper> mappers() {
        return this.fieldMappersAsList;
    }

    @Override
    public Iterator<FieldMapper> iterator() {
        return this.fieldMappersAsList.iterator();
    }

    public FieldMappers concat(FieldMapper mapper) {
        FieldMapper[] newMappers = new FieldMapper[this.fieldMappers.length + 1];
        System.arraycopy(this.fieldMappers, 0, newMappers, 0, this.fieldMappers.length);
        newMappers[this.fieldMappers.length] = mapper;
        return new FieldMappers(newMappers);
    }

    public FieldMappers remove(FieldMapper mapper) {
        ArrayList<FieldMapper> list = new ArrayList<FieldMapper>(this.fieldMappers.length);
        for (FieldMapper fieldMapper : this.fieldMappers) {
            if (fieldMapper.equals(mapper)) continue;
            list.add(fieldMapper);
        }
        return new FieldMappers(list.toArray(new FieldMapper[list.size()]));
    }
}

