/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway.none;

import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.SnapshotStatus;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.indices.recovery.RecoveryState;

public class NoneIndexShardGateway
extends AbstractIndexShardComponent
implements IndexShardGateway {
    private final InternalIndexShard indexShard;
    private final RecoveryState recoveryState = new RecoveryState();

    @Inject
    public NoneIndexShardGateway(ShardId shardId, @IndexSettings Settings indexSettings, IndexShard indexShard) {
        super(shardId, indexSettings);
        this.indexShard = (InternalIndexShard)indexShard;
    }

    public String toString() {
        return "_none_";
    }

    @Override
    public RecoveryState recoveryState() {
        return this.recoveryState;
    }

    @Override
    public void recover(boolean indexShouldExists, RecoveryState recoveryState) throws IndexShardGatewayRecoveryException {
        recoveryState.getIndex().startTime(System.currentTimeMillis());
        try {
            this.logger.debug("cleaning shard content before creation", new Object[0]);
            this.indexShard.store().deleteContent();
        }
        catch (IOException e) {
            this.logger.warn("failed to clean store before starting shard", e, new Object[0]);
        }
        this.indexShard.postRecovery("post recovery from gateway");
        recoveryState.getIndex().time(System.currentTimeMillis() - recoveryState.getIndex().startTime());
        recoveryState.getTranslog().startTime(System.currentTimeMillis());
        recoveryState.getTranslog().time(System.currentTimeMillis() - recoveryState.getIndex().startTime());
    }

    @Override
    public String type() {
        return "none";
    }

    @Override
    public SnapshotStatus snapshot(IndexShardGateway.Snapshot snapshot) {
        return null;
    }

    @Override
    public SnapshotStatus lastSnapshotStatus() {
        return null;
    }

    @Override
    public SnapshotStatus currentSnapshotStatus() {
        return null;
    }

    @Override
    public boolean requiresSnapshot() {
        return false;
    }

    @Override
    public boolean requiresSnapshotScheduling() {
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public IndexShardGateway.SnapshotLock obtainSnapshotLock() throws Exception {
        return NO_SNAPSHOT_LOCK;
    }
}

