/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.plain.BinaryDVNumericAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;

public class BinaryDVNumericIndexFieldData
extends DocValuesIndexFieldData
implements IndexNumericFieldData<BinaryDVNumericAtomicFieldData> {
    private final IndexNumericFieldData.NumericType numericType;

    public BinaryDVNumericIndexFieldData(Index index, FieldMapper.Names fieldNames, IndexNumericFieldData.NumericType numericType) {
        super(index, fieldNames);
        Preconditions.checkArgument(numericType != null, "numericType must be non-null");
        this.numericType = numericType;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, SortMode sortMode) {
        switch (this.numericType) {
            case FLOAT: {
                return new FloatValuesComparatorSource(this, missingValue, sortMode);
            }
            case DOUBLE: {
                return new DoubleValuesComparatorSource(this, missingValue, sortMode);
            }
        }
        assert (!this.numericType.isFloatingPoint());
        return new LongValuesComparatorSource(this, missingValue, sortMode);
    }

    @Override
    public BinaryDVNumericAtomicFieldData load(AtomicReaderContext context) {
        try {
            return new BinaryDVNumericAtomicFieldData(context.reader(), context.reader().getBinaryDocValues(this.fieldNames.indexName()), this.numericType);
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public BinaryDVNumericAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }
}

