/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;

public class IndicesFilterBuilder
extends BaseFilterBuilder {
    private final FilterBuilder filterBuilder;
    private final String[] indices;
    private String sNoMatchFilter;
    private FilterBuilder noMatchFilter;
    private String filterName;

    public IndicesFilterBuilder(FilterBuilder filterBuilder, String ... indices) {
        this.filterBuilder = filterBuilder;
        this.indices = indices;
    }

    public IndicesFilterBuilder noMatchFilter(String type) {
        this.sNoMatchFilter = type;
        return this;
    }

    public IndicesFilterBuilder noMatchFilter(FilterBuilder noMatchFilter) {
        this.noMatchFilter = noMatchFilter;
        return this;
    }

    public IndicesFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("indices");
        builder.field("indices", this.indices);
        builder.field("filter");
        this.filterBuilder.toXContent(builder, params);
        if (this.noMatchFilter != null) {
            builder.field("no_match_filter");
            this.noMatchFilter.toXContent(builder, params);
        } else if (this.sNoMatchFilter != null) {
            builder.field("no_match_filter", this.sNoMatchFilter);
        }
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        builder.endObject();
    }
}

