/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class IndexingMonitor {
    private AtomicInteger totalWorkerCounter = new AtomicInteger(0);
    private AtomicInteger runningCounter = new AtomicInteger(0);
    private static final ReentrantLock lock = new ReentrantLock();
    public static final Condition indexingDone = lock.newCondition();

    public int getTotalWorkerCount() {
        return this.totalWorkerCounter.get();
    }

    public int getPendingWorkerCount() {
        return this.totalWorkerCounter.get() - this.runningCounter.get();
    }

    public int getRunningWorkerCount() {
        return this.runningCounter.get();
    }

    public void incrementWorker() {
        this.totalWorkerCounter.incrementAndGet();
    }

    public void incrementRunningWorker() {
        this.runningCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementWorker() {
        this.runningCounter.decrementAndGet();
        if (this.totalWorkerCounter.decrementAndGet() == 0) {
            lock.lock();
            try {
                indexingDone.signalAll();
            }
            finally {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForWorkerToComplete() {
        if (this.totalWorkerCounter.get() == 0) {
            return;
        }
        lock.lock();
        try {
            indexingDone.await();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            lock.unlock();
        }
    }
}

