/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.gateway;

import java.util.concurrent.ScheduledFuture;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.CloseableIndexComponent;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.gateway.IgnoreGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGateway;
import org.elasticsearch.index.gateway.IndexShardGatewayRecoveryException;
import org.elasticsearch.index.gateway.IndexShardGatewaySnapshotFailedException;
import org.elasticsearch.index.gateway.SnapshotStatus;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.snapshots.IndexShardSnapshotAndRestoreService;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.threadpool.ThreadPool;

public class IndexShardGatewayService
extends AbstractIndexShardComponent
implements CloseableIndexComponent {
    private final boolean snapshotOnClose;
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final ClusterService clusterService;
    private final InternalIndexShard indexShard;
    private final IndexShardGateway shardGateway;
    private final IndexShardSnapshotAndRestoreService snapshotService;
    private volatile long lastIndexVersion;
    private volatile long lastTranslogId = -1L;
    private volatile int lastTotalTranslogOperations;
    private volatile long lastTranslogLength;
    private volatile TimeValue snapshotInterval;
    private volatile ScheduledFuture snapshotScheduleFuture;
    private RecoveryState recoveryState;
    private IndexShardGateway.SnapshotLock snapshotLock;
    private final SnapshotRunnable snapshotRunnable = new SnapshotRunnable();
    private final ApplySettings applySettings = new ApplySettings();
    public static final String INDEX_GATEWAY_SNAPSHOT_INTERVAL = "index.gateway.snapshot_interval";

    @Inject
    public IndexShardGatewayService(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, ThreadPool threadPool, IndexShard indexShard, IndexShardGateway shardGateway, IndexShardSnapshotAndRestoreService snapshotService, ClusterService clusterService) {
        super(shardId, indexSettings);
        this.threadPool = threadPool;
        this.indexSettingsService = indexSettingsService;
        this.indexShard = (InternalIndexShard)indexShard;
        this.shardGateway = shardGateway;
        this.snapshotService = snapshotService;
        this.recoveryState = new RecoveryState(shardId);
        this.clusterService = clusterService;
        this.snapshotOnClose = this.componentSettings.getAsBoolean("snapshot_on_close", (Boolean)true);
        this.snapshotInterval = this.componentSettings.getAsTime("snapshot_interval", TimeValue.timeValueSeconds(10L));
        indexSettingsService.addListener(this.applySettings);
    }

    public void routingStateChanged() {
        this.scheduleSnapshotIfNeeded();
    }

    public RecoveryState recoveryState() {
        if (this.recoveryState.getTimer().startTime() > 0L && this.recoveryState.getStage() != RecoveryState.Stage.DONE) {
            this.recoveryState.getTimer().time(System.currentTimeMillis() - this.recoveryState.getTimer().startTime());
        }
        return this.recoveryState;
    }

    public SnapshotStatus snapshotStatus() {
        SnapshotStatus snapshotStatus = this.shardGateway.currentSnapshotStatus();
        if (snapshotStatus != null) {
            return snapshotStatus;
        }
        return this.shardGateway.lastSnapshotStatus();
    }

    public void recover(final boolean indexShouldExists, final RecoveryListener listener) throws IndexShardGatewayRecoveryException, IgnoreGatewayRecoveryException {
        if (this.indexShard.state() == IndexShardState.CLOSED) {
            listener.onIgnoreRecovery("shard closed");
            return;
        }
        if (!this.indexShard.routingEntry().primary()) {
            listener.onRecoveryFailed(new IndexShardGatewayRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null));
            return;
        }
        try {
            if (this.indexShard.routingEntry().restoreSource() != null) {
                this.indexShard.recovering("from snapshot");
            } else {
                this.indexShard.recovering("from gateway");
            }
        }
        catch (IllegalIndexShardStateException e) {
            listener.onIgnoreRecovery("already in recovering process, " + e.getMessage());
            return;
        }
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                IndexShardGatewayService.this.recoveryState.getTimer().startTime(System.currentTimeMillis());
                IndexShardGatewayService.this.recoveryState.setTargetNode(IndexShardGatewayService.this.clusterService.localNode());
                IndexShardGatewayService.this.recoveryState.setStage(RecoveryState.Stage.INIT);
                IndexShardGatewayService.this.recoveryState.setPrimary(IndexShardGatewayService.this.indexShard.routingEntry().primary());
                try {
                    if (IndexShardGatewayService.this.indexShard.routingEntry().restoreSource() != null) {
                        IndexShardGatewayService.this.logger.debug("restoring from {} ...", IndexShardGatewayService.this.indexShard.routingEntry().restoreSource());
                        IndexShardGatewayService.this.recoveryState.setType(RecoveryState.Type.SNAPSHOT);
                        IndexShardGatewayService.this.recoveryState.setRestoreSource(IndexShardGatewayService.this.indexShard.routingEntry().restoreSource());
                        IndexShardGatewayService.this.snapshotService.restore(IndexShardGatewayService.this.recoveryState);
                    } else {
                        IndexShardGatewayService.this.logger.debug("starting recovery from {} ...", IndexShardGatewayService.this.shardGateway);
                        IndexShardGatewayService.this.recoveryState.setType(RecoveryState.Type.GATEWAY);
                        IndexShardGatewayService.this.recoveryState.setSourceNode(IndexShardGatewayService.this.clusterService.localNode());
                        IndexShardGatewayService.this.shardGateway.recover(indexShouldExists, IndexShardGatewayService.this.recoveryState);
                    }
                    IndexShardGatewayService.this.lastIndexVersion = IndexShardGatewayService.this.recoveryState.getIndex().version();
                    IndexShardGatewayService.this.lastTranslogId = -1L;
                    IndexShardGatewayService.this.lastTranslogLength = 0L;
                    IndexShardGatewayService.this.lastTotalTranslogOperations = IndexShardGatewayService.this.recoveryState.getTranslog().currentTranslogOperations();
                    IndexShardState shardState = IndexShardGatewayService.this.indexShard.state();
                    if (shardState != IndexShardState.POST_RECOVERY && shardState != IndexShardState.STARTED) {
                        IndexShardGatewayService.this.indexShard.postRecovery("post recovery from gateway");
                    }
                    IndexShardGatewayService.this.indexShard.refresh(new Engine.Refresh("post_gateway").force(true));
                    IndexShardGatewayService.this.recoveryState.getTimer().time(System.currentTimeMillis() - IndexShardGatewayService.this.recoveryState.getTimer().startTime());
                    IndexShardGatewayService.this.recoveryState.setStage(RecoveryState.Stage.DONE);
                    if (IndexShardGatewayService.this.logger.isTraceEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("recovery completed from ").append(IndexShardGatewayService.this.shardGateway).append(", took [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getTimer().time())).append("]\n");
                        sb.append("    index    : files           [").append(IndexShardGatewayService.this.recoveryState.getIndex().totalFileCount()).append("] with total_size [").append(new ByteSizeValue(IndexShardGatewayService.this.recoveryState.getIndex().totalByteCount())).append("], took[").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getIndex().time())).append("]\n");
                        sb.append("             : recovered_files [").append(IndexShardGatewayService.this.recoveryState.getIndex().numberOfRecoveredFiles()).append("] with total_size [").append(new ByteSizeValue(IndexShardGatewayService.this.recoveryState.getIndex().recoveredTotalSize())).append("]\n");
                        sb.append("             : reusing_files   [").append(IndexShardGatewayService.this.recoveryState.getIndex().reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(IndexShardGatewayService.this.recoveryState.getIndex().reusedByteCount())).append("]\n");
                        sb.append("    start    : took [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getStart().time())).append("], check_index [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getStart().checkIndexTime())).append("]\n");
                        sb.append("    translog : number_of_operations [").append(IndexShardGatewayService.this.recoveryState.getTranslog().currentTranslogOperations()).append("], took [").append(TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getTranslog().time())).append("]");
                        IndexShardGatewayService.this.logger.trace(sb.toString(), new Object[0]);
                    } else if (IndexShardGatewayService.this.logger.isDebugEnabled()) {
                        IndexShardGatewayService.this.logger.debug("recovery completed from [{}], took [{}]", IndexShardGatewayService.this.shardGateway, TimeValue.timeValueMillis(IndexShardGatewayService.this.recoveryState.getTimer().time()));
                    }
                    listener.onRecoveryDone();
                    IndexShardGatewayService.this.scheduleSnapshotIfNeeded();
                }
                catch (IndexShardGatewayRecoveryException e) {
                    if (IndexShardGatewayService.this.indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    if (e.getCause() instanceof IndexShardClosedException || e.getCause() instanceof IndexShardNotStartedException) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(e);
                }
                catch (IndexShardClosedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (IndexShardNotStartedException e) {
                    listener.onIgnoreRecovery("shard closed");
                }
                catch (Exception e) {
                    if (IndexShardGatewayService.this.indexShard.state() == IndexShardState.CLOSED) {
                        listener.onIgnoreRecovery("shard closed");
                        return;
                    }
                    listener.onRecoveryFailed(new IndexShardGatewayRecoveryException(IndexShardGatewayService.this.shardId, "failed recovery", (Throwable)e));
                }
            }
        });
    }

    public synchronized void snapshot(final String reason) throws IndexShardGatewaySnapshotFailedException {
        if (!this.indexShard.routingEntry().primary()) {
            return;
        }
        if (this.indexShard.routingEntry().relocating()) {
            return;
        }
        if (this.indexShard.state() == IndexShardState.CREATED) {
            return;
        }
        if (this.indexShard.state() == IndexShardState.RECOVERING) {
            return;
        }
        if (this.snapshotLock == null) {
            try {
                this.snapshotLock = this.shardGateway.obtainSnapshotLock();
            }
            catch (Exception e) {
                this.logger.warn("failed to obtain snapshot lock, ignoring snapshot", e, new Object[0]);
                return;
            }
        }
        try {
            SnapshotStatus snapshotStatus = this.indexShard.snapshot(new Engine.SnapshotHandler<SnapshotStatus>(){

                @Override
                public SnapshotStatus snapshot(SnapshotIndexCommit snapshotIndexCommit, Translog.Snapshot translogSnapshot) throws EngineException {
                    if (IndexShardGatewayService.this.lastIndexVersion != snapshotIndexCommit.getGeneration() || IndexShardGatewayService.this.lastTranslogId != translogSnapshot.translogId() || IndexShardGatewayService.this.lastTranslogLength < translogSnapshot.length()) {
                        IndexShardGatewayService.this.logger.debug("snapshot ({}) to {} ...", reason, IndexShardGatewayService.this.shardGateway);
                        SnapshotStatus snapshotStatus = IndexShardGatewayService.this.shardGateway.snapshot(new IndexShardGateway.Snapshot(snapshotIndexCommit, translogSnapshot, IndexShardGatewayService.this.lastIndexVersion, IndexShardGatewayService.this.lastTranslogId, IndexShardGatewayService.this.lastTranslogLength, IndexShardGatewayService.this.lastTotalTranslogOperations));
                        IndexShardGatewayService.this.lastIndexVersion = snapshotIndexCommit.getGeneration();
                        IndexShardGatewayService.this.lastTranslogId = translogSnapshot.translogId();
                        IndexShardGatewayService.this.lastTranslogLength = translogSnapshot.length();
                        IndexShardGatewayService.this.lastTotalTranslogOperations = translogSnapshot.estimatedTotalOperations();
                        return snapshotStatus;
                    }
                    return null;
                }
            });
            if (snapshotStatus != null && this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("snapshot (").append(reason).append(") completed to ").append(this.shardGateway).append(", took [").append(TimeValue.timeValueMillis(snapshotStatus.time())).append("]\n");
                sb.append("    index    : version [").append(this.lastIndexVersion).append("], number_of_files [").append(snapshotStatus.index().numberOfFiles()).append("] with total_size [").append(new ByteSizeValue(snapshotStatus.index().totalSize())).append("], took [").append(TimeValue.timeValueMillis(snapshotStatus.index().time())).append("]\n");
                sb.append("    translog : id      [").append(this.lastTranslogId).append("], number_of_operations [").append(snapshotStatus.translog().expectedNumberOfOperations()).append("], took [").append(TimeValue.timeValueMillis(snapshotStatus.translog().time())).append("]");
                this.logger.debug(sb.toString(), new Object[0]);
            }
        }
        catch (SnapshotFailedEngineException e) {
            if (!(e.getCause() instanceof IllegalStateException)) {
                throw new IndexShardGatewaySnapshotFailedException(this.shardId, "Failed to snapshot", (Throwable)e);
            }
        }
        catch (IllegalIndexShardStateException e) {
        }
        catch (IndexShardGatewaySnapshotFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexShardGatewaySnapshotFailedException(this.shardId, "Failed to snapshot", (Throwable)e);
        }
    }

    public void snapshotOnClose() {
        if (this.shardGateway.requiresSnapshot() && this.snapshotOnClose) {
            try {
                this.snapshot("shutdown");
            }
            catch (Exception e) {
                this.logger.warn("failed to snapshot on close", e, new Object[0]);
            }
        }
    }

    @Override
    public synchronized void close() {
        this.indexSettingsService.removeListener(this.applySettings);
        if (this.snapshotScheduleFuture != null) {
            this.snapshotScheduleFuture.cancel(true);
            this.snapshotScheduleFuture = null;
        }
        this.shardGateway.close();
        if (this.snapshotLock != null) {
            this.snapshotLock.release();
        }
    }

    private synchronized void scheduleSnapshotIfNeeded() {
        if (!this.shardGateway.requiresSnapshot()) {
            return;
        }
        if (!this.shardGateway.requiresSnapshotScheduling()) {
            return;
        }
        if (!this.indexShard.routingEntry().primary()) {
            return;
        }
        if (!this.indexShard.routingEntry().started()) {
            return;
        }
        if (this.snapshotScheduleFuture != null) {
            return;
        }
        if (this.snapshotInterval.millis() != -1L) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("scheduling snapshot every [{}]", this.snapshotInterval);
            }
            this.snapshotScheduleFuture = this.threadPool.schedule(this.snapshotInterval, "snapshot", this.snapshotRunnable);
        }
    }

    private class SnapshotRunnable
    implements Runnable {
        private SnapshotRunnable() {
        }

        @Override
        public synchronized void run() {
            try {
                IndexShardGatewayService.this.snapshot("scheduled");
            }
            catch (Throwable e) {
                if (IndexShardGatewayService.this.indexShard.state() == IndexShardState.CLOSED) {
                    return;
                }
                IndexShardGatewayService.this.logger.warn("failed to snapshot (scheduled)", e, new Object[0]);
            }
            if (IndexShardGatewayService.this.indexShard.state() != IndexShardState.CLOSED) {
                IndexShardGatewayService.this.snapshotScheduleFuture = IndexShardGatewayService.this.threadPool.schedule(IndexShardGatewayService.this.snapshotInterval, "snapshot", this);
            }
        }
    }

    public static interface RecoveryListener {
        public void onRecoveryDone();

        public void onIgnoreRecovery(String var1);

        public void onRecoveryFailed(IndexShardGatewayRecoveryException var1);
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            TimeValue snapshotInterval = settings.getAsTime(IndexShardGatewayService.INDEX_GATEWAY_SNAPSHOT_INTERVAL, IndexShardGatewayService.this.snapshotInterval);
            if (!snapshotInterval.equals(IndexShardGatewayService.this.snapshotInterval)) {
                IndexShardGatewayService.this.logger.info("updating snapshot_interval from [{}] to [{}]", IndexShardGatewayService.this.snapshotInterval, snapshotInterval);
                IndexShardGatewayService.this.snapshotInterval = snapshotInterval;
                if (IndexShardGatewayService.this.snapshotScheduleFuture != null) {
                    IndexShardGatewayService.this.snapshotScheduleFuture.cancel(false);
                    IndexShardGatewayService.this.snapshotScheduleFuture = null;
                }
                IndexShardGatewayService.this.scheduleSnapshotIfNeeded();
            }
        }
    }
}

