/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.work;

import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.elasticsearch.api.ElasticSearchIndexing;
import org.nuxeo.elasticsearch.commands.IndexingCommand;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractIndexingWorker
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    protected final IndexingCommand cmd;
    protected final String path;

    public AbstractIndexingWorker(IndexingCommand cmd) {
        this.cmd = cmd;
        this.path = cmd.getTargetDocument().getPathAsString();
    }

    public String getCategory() {
        return "elasticSearchIndexing";
    }

    public void work() throws Exception {
        CoreSession session = this.initSession(this.repositoryName);
        ElasticSearchIndexing esi = (ElasticSearchIndexing)Framework.getLocalService(ElasticSearchIndexing.class);
        this.cmd.refresh(session);
        this.doIndexingWork(esi, this.cmd);
    }

    protected abstract void doIndexingWork(ElasticSearchIndexing var1, IndexingCommand var2) throws Exception;
}

