/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.operations;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;

@Operation(id="NuxeoDrive.AttachBlob", category="Services", label="Nuxeo Drive: Attach blob", description="Update the given document with the input blob. Return the input blob.")
public class NuxeoDriveAttachBlob {
    public static final String ID = "NuxeoDrive.AttachBlob";
    @Context
    protected CoreSession session;
    @Param(name="document", description="The document to update.")
    protected DocumentModel doc;
    @Deprecated
    @Param(name="applyVersioningPolicy", required=false, values={"false"})
    protected boolean applyVersioningPolicy = false;
    @Deprecated
    @Param(name="factoryName", required=false, values={"defaultFileSystemItemFactory"})
    protected String factoryName = "defaultFileSystemItemFactory";

    @OperationMethod
    public Blob run(Blob blob) {
        BlobHolder bh = (BlobHolder)this.doc.getAdapter(BlobHolder.class);
        if (bh == null) {
            throw new NuxeoException(String.format("Document %s is not a BlobHolder, no blob can be attached to it.", this.doc.getId()));
        }
        bh.setBlob(blob);
        this.session.saveDocument(this.doc);
        return blob;
    }
}

