/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.listener;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class NuxeoDriveVirtualEventLogger
implements PostCommitFilteringEventListener {
    private static final Log log = LogFactory.getLog(NuxeoDriveVirtualEventLogger.class);

    public boolean acceptEvent(Event event) {
        return "virtualEventCreated".equals(event.getName());
    }

    public void handleEvent(EventBundle events) {
        AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
        if (logger != null) {
            for (Event event : events) {
                EventContext ctx = event.getContext();
                Object[] args = ctx.getArguments();
                if (ArrayUtils.isEmpty((Object[])args)) {
                    return;
                }
                ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>();
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    if (!(arg instanceof LogEntry)) continue;
                    logEntries.add((LogEntry)arg);
                }
                if (logEntries.isEmpty()) continue;
                logger.addLogEntries(logEntries);
            }
        } else {
            log.error((Object)"Can not reach AuditLogger");
        }
    }
}

