/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.TopLevelFolderItemFactoryDescriptor;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class TopLevelFolderItemFactoryRegistry
extends ContributionFragmentRegistry<TopLevelFolderItemFactoryDescriptor> {
    private static final Log log = LogFactory.getLog(TopLevelFolderItemFactoryRegistry.class);
    protected Map<String, TopLevelFolderItemFactory> factories = new HashMap<String, TopLevelFolderItemFactory>();

    public String getContributionId(TopLevelFolderItemFactoryDescriptor contrib) {
        String name = contrib.getName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new NuxeoException("Cannot register topLevelFolderItemFactory without a name.");
        }
        return name;
    }

    public void contributionUpdated(String id, TopLevelFolderItemFactoryDescriptor contrib, TopLevelFolderItemFactoryDescriptor newOrigContrib) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Putting contribution with class name %s in factory registry.", contrib.getName()));
            }
            this.factories.put(id, contrib.getFactory());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new NuxeoException("Cannot update topLevelFolderItemFactory contribution.", (Throwable)e);
        }
    }

    public void contributionRemoved(String id, TopLevelFolderItemFactoryDescriptor origContrib) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Removing contribution with class name %s in factory registry.", id));
        }
        this.factories.remove(id);
    }

    public TopLevelFolderItemFactoryDescriptor clone(TopLevelFolderItemFactoryDescriptor orig) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Cloning contribution with class name %s.", orig.getName()));
        }
        TopLevelFolderItemFactoryDescriptor clone = new TopLevelFolderItemFactoryDescriptor();
        clone.factoryClass = orig.factoryClass;
        clone.parameters = orig.parameters;
        return clone;
    }

    public void merge(TopLevelFolderItemFactoryDescriptor src, TopLevelFolderItemFactoryDescriptor dst) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Merging contribution with class name %s to contribution with class name %s", src.getName(), dst.getName()));
        }
        if (src.getFactoryClass() != null && !src.getFactoryClass().equals(dst.getFactoryClass())) {
            dst.setFactoryClass(src.getFactoryClass());
        }
        if (!MapUtils.isEmpty(src.getParameters())) {
            for (String name : src.getParameters().keySet()) {
                dst.setParameter(name, src.getparameter(name));
            }
        }
    }

    protected TopLevelFolderItemFactory getActiveFactory(String activeFactory) {
        return this.factories.get(activeFactory);
    }
}

