/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.jtajca.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerMonitor;
import org.apache.geronimo.transaction.manager.XidImpl;
import org.apache.log4j.MDC;
import org.javasimon.SimonManager;
import org.javasimon.Stopwatch;
import org.nuxeo.ecm.core.management.jtajca.TransactionMonitor;
import org.nuxeo.ecm.core.management.jtajca.TransactionStatistics;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultMonitorComponent;
import org.nuxeo.ecm.core.management.jtajca.internal.DefaultTransactionStatistics;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class DefaultTransactionMonitor
implements TransactionManagerMonitor,
TransactionMonitor,
Synchronization {
    protected static final Log log = LogFactory.getLog(DefaultTransactionMonitor.class);
    protected TransactionManagerImpl tm;
    protected boolean enabled;
    protected DefaultMonitorComponent.ServerInstance self;
    protected TransactionStatistics lastCommittedStatistics;
    protected TransactionStatistics lastRollbackedStatistics;
    protected final Map<Object, DefaultTransactionStatistics> activeStatistics = new HashMap<Object, DefaultTransactionStatistics>();

    @Override
    public void install() {
        this.tm = this.lookup();
        if (this.tm == null) {
            log.warn((Object)"Cannot monitor transactions, not a geronimo tx manager");
            return;
        }
        this.bindManagementInterface();
        this.toggle();
    }

    @Override
    public void uninstall() {
        if (this.tm == null) {
            return;
        }
        this.unbindManagementInterface();
        if (this.enabled) {
            this.toggle();
        }
    }

    protected void bindManagementInterface() {
        this.self = DefaultMonitorComponent.bind(TransactionMonitor.class, this);
    }

    protected void unbindManagementInterface() {
        DefaultMonitorComponent.unbind(this.self);
        this.self = null;
    }

    protected TransactionManagerImpl lookup() {
        TransactionManager tm = NuxeoContainer.getTransactionManager();
        if (tm == null) {
            try {
                tm = TransactionHelper.lookupTransactionManager();
            }
            catch (NamingException cause) {
                throw new RuntimeException("Cannot lookup tx manager", cause);
            }
        }
        if (!(tm instanceof TransactionManagerImpl)) {
            return null;
        }
        return (TransactionManagerImpl)tm;
    }

    public static String id(Object key) {
        if (key instanceof XidImpl) {
            byte[] globalId = ((XidImpl)key).getGlobalTransactionId();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < globalId.length; ++i) {
                buffer.append(Integer.toHexString(globalId[i]));
            }
            return buffer.toString().replaceAll("0*$", "");
        }
        return key.toString();
    }

    public static String id(Transaction tx) {
        return Integer.toHexString(tx.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadAssociated(Transaction tx) {
        long now = System.currentTimeMillis();
        Object key = this.tm.getTransactionKey();
        MDC.put((String)"tx", (Object)DefaultTransactionMonitor.id(key));
        Stopwatch sw = SimonManager.getStopwatch((String)"tx");
        Thread thread = Thread.currentThread();
        DefaultTransactionStatistics info = new DefaultTransactionStatistics(key);
        info.split = sw.start();
        info.threadName = thread.getName();
        info.status = TransactionStatistics.Status.fromTx(tx);
        info.startTimestamp = now;
        info.startCapturedContext = new Throwable("** start invoke context **");
        DefaultTransactionMonitor defaultTransactionMonitor = this;
        synchronized (defaultTransactionMonitor) {
            this.activeStatistics.put(key, info);
        }
        if (TransactionStatistics.Status.ACTIVE == info.status) {
            this.tm.registerInterposedSynchronization((Synchronization)this);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)info.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void threadUnassociated(Transaction tx) {
        try {
            Object key = ((TransactionImpl)tx).getTransactionKey();
            Class<DefaultTransactionMonitor> clazz = DefaultTransactionMonitor.class;
            synchronized (DefaultTransactionMonitor.class) {
                DefaultTransactionStatistics stats = this.activeStatistics.remove(key);
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (stats == null) {
                    log.debug((Object)(key + " not found in active statistics map"));
                    return;
                }
                stats.split.stop();
                stats.split = null;
                if (log.isTraceEnabled()) {
                    log.trace((Object)stats);
                }
                if (TransactionStatistics.Status.COMMITTED.equals((Object)stats.status)) {
                    this.lastCommittedStatistics = stats;
                } else if (TransactionStatistics.Status.ROLLEDBACK.equals((Object)stats.status)) {
                    this.lastRollbackedStatistics = stats;
                }
            }
        }
        finally {
            MDC.remove((String)"tx");
        }
        {
            return;
        }
    }

    @Override
    public List<TransactionStatistics> getActiveStatistics() {
        ArrayList<TransactionStatistics> l = new ArrayList<TransactionStatistics>(this.activeStatistics.values());
        Collections.sort(l, new Comparator<TransactionStatistics>(){

            @Override
            public int compare(TransactionStatistics o1, TransactionStatistics o2) {
                return o1.getStartDate().compareTo(o2.getEndDate());
            }
        });
        return l;
    }

    @Override
    public long getActiveCount() {
        return this.tm.getActiveCount();
    }

    @Override
    public long getTotalCommits() {
        return this.tm.getTotalCommits();
    }

    @Override
    public long getTotalRollbacks() {
        return this.tm.getTotalRollbacks();
    }

    @Override
    public TransactionStatistics getLastCommittedStatistics() {
        return this.lastCommittedStatistics;
    }

    @Override
    public TransactionStatistics getLastRollbackedStatistics() {
        return this.lastRollbackedStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultTransactionStatistics thisStatistics() {
        DefaultTransactionStatistics stats;
        Object key = this.tm.getTransactionKey();
        DefaultTransactionMonitor defaultTransactionMonitor = this;
        synchronized (defaultTransactionMonitor) {
            stats = this.activeStatistics.get(key);
        }
        if (stats == null) {
            log.debug((Object)(key + " not found in active statistics map"));
        }
        return stats;
    }

    public void beforeCompletion() {
        DefaultTransactionStatistics stats = this.thisStatistics();
        if (stats == null) {
            return;
        }
        stats.endCapturedContext = new Throwable("** end invoke context **");
    }

    public void afterCompletion(int code) {
        DefaultTransactionStatistics stats = this.thisStatistics();
        if (stats == null) {
            return;
        }
        stats.endTimestamp = System.currentTimeMillis();
        stats.status = TransactionStatistics.Status.fromCode(code);
        switch (code) {
            case 3: {
                this.lastCommittedStatistics = stats;
                break;
            }
            case 4: {
                this.lastRollbackedStatistics = stats;
                stats.endCapturedContext = new Throwable("** rollback context **");
            }
        }
    }

    @Override
    public boolean toggle() {
        if (this.enabled) {
            this.tm.removeTransactionAssociationListener((TransactionManagerMonitor)this);
            this.activeStatistics.clear();
            this.enabled = false;
        } else {
            this.tm.addTransactionAssociationListener((TransactionManagerMonitor)this);
            this.enabled = true;
        }
        return this.enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }
}

